package com.digiwin.dap.middle.ram.service.authentication;

import com.digiwin.dap.middle.ram.service.authentication.handler.*;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;
import com.digiwin.dap.middleware.auth.domain.RequestInfo;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

import java.util.ArrayList;
import java.util.List;

/**
 * 授权策略组合服务
 *
 * @author fobgochod
 * @date 2022/4/12 17:18
 */
public class AuthCheckHandlerComposite extends AuthCheckHandler {

    private final List<AuthCheckHandler> handlers = new ArrayList<>(5);

    public AuthCheckHandlerComposite(AuthCheckService authCheckService, RamCoreService ramCoreService) {
        this.handlers.add(new BeforeAuthCheckHandler(ramCoreService));
        this.handlers.add(new NoAuthAuthCheckHandler(ramCoreService));
        this.handlers.add(new DoAuthCheckHandler(authCheckService));
        this.handlers.add(new NoAuthAppAuthCheckHandler(ramCoreService));
        this.handlers.add(new NoAuthUserAuthCheckHandler(ramCoreService));
        AnnotationAwareOrderComparator.sort(this.handlers);
    }

    @Override
    public boolean supports(AuthType authType) {
        return false;
    }

    @Override
    public AuthResult processAuth(AuthResult authResult, AuthoredUser user, AuthoredSys sys, RequestInfo request) {
        for (AuthCheckHandler handler : handlers) {
            if (handler.supports(authResult.getAuthType())) {
                AuthResult temp = handler.processAuth(authResult, user, sys, request);
                if (temp.getAuthType() == AuthType.AppOk) {
                    return temp;
                }
                authResult = temp;
            }
        }
        return authResult;
    }
}
