package com.digiwin.dap.middle.ram.service.base.impl;

import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.page.Filter;
import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.entity.Policy;
import com.digiwin.dap.middle.ram.mapper.RamPolicyMapper;
import com.digiwin.dap.middle.ram.service.base.RamPolicyCrudService;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class RamPolicyCrudServiceImpl implements RamPolicyCrudService {

    @Autowired
    private RamPolicyMapper ramPolicyMapper;

    @Override
    public long insert(Policy data) {
        data.setSid(SnowFlake.getInstance().newId());
        BaseUtils.setCreateFields(data);
        ramPolicyMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return ramPolicyMapper.deleteBySid(sid);
    }

    @Override
    public long update(Policy data) {
        BaseUtils.setModifyFields(data);
        ramPolicyMapper.update(data);
        return data.getSid();
    }

    @Override
    public Policy findBySid(long sid) {
        return ramPolicyMapper.findBySid(sid);
    }

    @Override
    public boolean exists(Policy data) {
        return ramPolicyMapper.exists(data.getSid());
    }

    @Override
    public PageData<PolicyVO> findByPage(Page<Policy> page) {
        Filter<Policy> filter = page.filter();
        long total = ramPolicyMapper.countByPage(filter.getEq(), filter);
        if (total == 0) {
            return PageData.empty();
        }
        List<PolicyVO> paths = ramPolicyMapper.findByPage(filter.getEq(), filter);
        return PageData.data(total, paths);
    }

    @Override
    public List<Policy> findByCond(Policy data) {
        return ramPolicyMapper.findByCond(data);
    }

    @Override
    public Policy findByAppAndType(String appId, String policyType) {
        return ramPolicyMapper.findByAppAndType(appId, policyType);
    }
}
