package com.digiwin.dap.middle.ram.service.base.impl;

import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.domain.RouteVO;
import com.digiwin.dap.middle.ram.domain.page.Filter;
import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.entity.Route;
import com.digiwin.dap.middle.ram.mapper.RamRouteMapper;
import com.digiwin.dap.middle.ram.service.base.RamRouteCrudService;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class RamRouteCrudServiceImpl implements RamRouteCrudService {

    @Autowired
    private RamRouteMapper ramRouteMapper;

    @Override
    public long insert(Route data) {
        data.setSid(SnowFlake.getInstance().newId());
        BaseUtils.setCreateFields(data);
        ramRouteMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return ramRouteMapper.deleteBySid(sid);
    }

    @Override
    public long update(Route data) {
        BaseUtils.setCreateFields(data);
        ramRouteMapper.update(data);
        return data.getSid();
    }

    @Override
    public Route findBySid(long sid) {
        return ramRouteMapper.findBySid(sid);
    }

    @Override
    public boolean exists(Route data) {
        return ramRouteMapper.existsBySid(data.getSid());
    }

    @Override
    public PageData<RouteVO> findByPage(Page<Route> page) {
        Filter<Route> filter = page.filter();
        long total = ramRouteMapper.countByPage(filter.getEq(), filter);
        if (total == 0) {
            return PageData.empty();
        }
        List<RouteVO> paths = ramRouteMapper.findByPage(filter.getEq(), filter);
        return PageData.data(total, paths);
    }

    @Override
    public List<Route> findByCond(Route data) {
        return ramRouteMapper.findByCond(data);
    }
}
