package com.digiwin.dap.middle.ram.service.executor.cache;

import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.service.executor.GrantExecutor;
import com.digiwin.dap.middleware.constant.CacheConstants;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;

import java.util.List;

@CacheConfig(cacheNames = CacheConstants.TTL_12H, cacheManager = CacheConstants.DAP_CACHE_MANAGER)
public class GrantCachingExecutor implements GrantExecutor {

    private final GrantExecutor delegate;

    public GrantCachingExecutor(GrantExecutor delegate) {
        this.delegate = delegate;
    }

    @Cacheable(key = "T(com.digiwin.dap.middle.ram.constant.CacheConstant).RAM_GRANT + #app + ':' + #targetType + ':' + #targetId")
    @Override
    public List<PolicyVO> findPolicyIdByTarget(String app, String targetType, String targetId) {
        return delegate.findPolicyIdByTarget(app, targetType, targetId);
    }
}
