package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.entity.BaseSid;
import com.digiwin.dap.middle.ram.entity.Grant;
import com.digiwin.dap.middle.ram.service.base.RamGrantCrudService;
import com.digiwin.dap.middle.ram.service.base.RamGrantPolicyCrudService;
import com.digiwin.dap.middle.ram.service.core.RamCacheService;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 目标授权信息
 *
 * @author fobgochod
 * @date 2021/8/19 9:31
 */
@RequestMapping("/api/ram/v2/grant")
@RestController
public class RamGrantController {

    @Autowired
    private RamGrantCrudService ramGrantCrudService;
    @Autowired
    private RamCacheService ramCacheService;
    @Autowired
    private RamGrantPolicyCrudService ramGrantPolicyCrudService;

    @PostMapping("/add")
    public StdData<?> add(@RequestBody Grant body) {
        long sid = ramGrantCrudService.insert(body);
        return StdData.ok(BaseSid.ok(sid));
    }

    @Transactional
    @PostMapping("/del")
    public StdData<?> del(@RequestBody BaseSid body) {
        Grant grant = ramGrantCrudService.findBySid(body.getSid());
        if (grant == null) {
            return StdData.ok(BaseSid.ok(0));
        }
        ramGrantCrudService.deleteBySid(body.getSid());
        ramGrantPolicyCrudService.deleteByGrantSid(body.getSid());
        ramCacheService.grantRemove(grant);
        return StdData.ok(BaseSid.ok(body.getSid()));
    }

    @PostMapping("/get")
    public StdData<?> get(@RequestBody BaseSid body) {
        Grant grant = ramGrantCrudService.findBySid(body.getSid());
        return StdData.ok(grant);
    }

    @PostMapping("/find")
    public StdData<?> find(@RequestBody Grant body) {
        return StdData.ok(ramGrantCrudService.findByCond(body));
    }

    @PostMapping("/query")
    public StdData<?> query(@RequestBody Page<Grant> body) {
        body.setOrderBy("g.create_date desc");
        return StdData.ok(ramGrantCrudService.findByPage(body));
    }
}
