package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.GrantVO;
import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.entity.BaseSid;
import com.digiwin.dap.middle.ram.entity.GrantPolicy;
import com.digiwin.dap.middle.ram.service.base.RamGrantPolicyCrudService;
import com.digiwin.dap.middle.ram.service.core.RamCacheService;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 目标策略
 *
 * @author fobgochod
 * @date 2021/8/19 9:31
 */
@RequestMapping("/api/ram/v2/gp")
@RestController
public class RamGrantPolicyController {

    @Autowired
    private RamCacheService ramCacheService;
    @Autowired
    private RamGrantPolicyCrudService ramGrantPolicyCrudService;

    @PostMapping("/add")
    public StdData<?> add(@RequestBody GrantPolicy body) {
        long sid = ramGrantPolicyCrudService.insert(body);
        ramCacheService.grantPolicyChange(body.getGrantSid());
        return StdData.ok(BaseSid.ok(sid));
    }

    @PostMapping("/del")
    public StdData<?> del(@RequestBody BaseSid body) {
        GrantPolicy grantPolicy = ramGrantPolicyCrudService.findBySid(body.getSid());
        if (grantPolicy == null) {
            return StdData.ok(BaseSid.ok(0));
        }
        ramGrantPolicyCrudService.deleteBySid(body.getSid());
        ramCacheService.grantPolicyChange(grantPolicy.getGrantSid());
        return StdData.ok(BaseSid.ok(body.getSid()));
    }

    @PostMapping("/query")
    public StdData<?> find(@RequestBody Page<GrantVO> body) {
        body.setOrderBy("gp.create_date desc");
        return StdData.ok(ramGrantPolicyCrudService.findByPage(body));
    }

    @PostMapping("/find/grant")
    public StdData<?> getGrant(@RequestBody GrantPolicy body) {
        List<GrantVO> grants = ramGrantPolicyCrudService.findByPolicySid(body.getPolicySid());
        return StdData.ok(grants);
    }

    @PostMapping("/find/policy")
    public StdData<?> getPolicy(@RequestBody GrantPolicy body) {
        List<PolicyVO> policies = ramGrantPolicyCrudService.findByGrantSid(body.getGrantSid());
        return StdData.ok(policies);
    }
}
