package com.digiwin.dap.middle.ram.mapper;

import com.digiwin.dap.middle.ram.domain.GrantVO;
import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.page.Filter;
import com.digiwin.dap.middle.ram.entity.GrantPolicy;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface RamGrantPolicyMapper {

    int insert(@Param("entity") GrantPolicy entity);

    int deleteBySid(@Param("sid") long sid);

    int update(@Param("entity") GrantPolicy entity);

    GrantPolicy findBySid(@Param("sid") long sid);

    boolean exists(@Param("grantSid") long grantSid, @Param("policySid") long policySid);

    int deleteByGrantSid(@Param("grantSid") long grantSid);

    List<GrantVO> findByPolicySid(@Param("policySid") long policySid);

    List<PolicyVO> findByGrantSid(@Param("grantSid") long grantSid);

    long countByPage(@Param("cond") GrantVO cond, @Param("filter") Filter<?> filter);

    List<GrantVO> findByPage(@Param("cond") GrantVO cond, @Param("filter") Filter<?> filter);

    List<GrantPolicy> getByPolicySid(@Param("policySid") long policySid);
}
