package com.digiwin.dap.middle.ram.service;

import com.digiwin.dap.middle.ram.constant.RamConstant;
import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.condition.MappingInfo;
import com.digiwin.dap.middle.ram.entity.Route;
import com.digiwin.dap.middle.ram.mapper.RamRouteMapper;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 按应用缓存所有的路由信息
 *
 * @author fobgochod
 * @date 2022/5/19 17:26
 */
@Component
public class MappingInfoRegistry implements InitializingBean {

    private final MappingRegistry internalMappingRegistry = new MappingRegistry();
    private final Map<String, MappingRegistry> appMappingRegistries = new ConcurrentHashMap<>();

    @Autowired
    private RamRouteMapper ramRouteMapper;

    @Override
    public void afterPropertiesSet() {
        // initMappingInfos();
    }

    private void initMappingInfos() {
        List<Route> routes = ramRouteMapper.findAll();
        for (Route route : routes) {
            MappingRegistry mappingRegistry = this.getMappingRegistry(route.getApp());

            MappingInfo.Builder builder = MappingInfo.paths(route.getPath()).methods(MappingInfo.getMethod(route.getMethod()));
            mappingRegistry.register(builder.options(mappingRegistry.getConfig()).build(), new PatternVO(route));
        }
    }

    public MappingRegistry getMappingRegistry(String app) {
        if (GlobalConstants.MIDDLEWARE.equals(app)) {
            return internalMappingRegistry;
        }
        if (!appMappingRegistries.containsKey(app)) {
            appMappingRegistries.put(app, new MappingRegistry());
        }
        return appMappingRegistries.get(app);
    }
}
