package com.digiwin.dap.middle.ram.service.base.impl;

import com.digiwin.dap.middle.ram.domain.GrantVO;
import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.page.Filter;
import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.entity.GrantPolicy;
import com.digiwin.dap.middle.ram.mapper.RamGrantPolicyMapper;
import com.digiwin.dap.middle.ram.service.base.RamGrantPolicyCrudService;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class RamGrantPolicyCrudServiceImpl implements RamGrantPolicyCrudService {

    @Autowired
    private RamGrantPolicyMapper ramGrantPolicyMapper;

    @Override
    public long insert(GrantPolicy data) {
        data.setSid(SnowFlake.getInstance().newId());
        BaseUtils.setCreateFields(data);
        ramGrantPolicyMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return ramGrantPolicyMapper.deleteBySid(sid);
    }

    @Override
    public long update(GrantPolicy data) {
        ramGrantPolicyMapper.update(data);
        return data.getSid();
    }

    @Override
    public GrantPolicy findBySid(long sid) {
        return ramGrantPolicyMapper.findBySid(sid);
    }

    @Override
    public boolean exists(GrantPolicy data) {
        return ramGrantPolicyMapper.exists(data.getGrantSid(), data.getPolicySid());
    }

    public int deleteByGrantSid(long grantSid) {
        return ramGrantPolicyMapper.deleteByGrantSid(grantSid);
    }

    public List<GrantVO> findByPolicySid(long policySid) {
        return ramGrantPolicyMapper.findByPolicySid(policySid);
    }

    public List<PolicyVO> findByGrantSid(long grantSid) {
        return ramGrantPolicyMapper.findByGrantSid(grantSid);
    }

    public PageData<GrantVO> findByPage(Page<GrantVO> page) {
        Filter<GrantVO> filter = page.filter();
        long total = ramGrantPolicyMapper.countByPage(filter.getEq(), filter);
        if (total == 0) {
            return PageData.empty();
        }
        List<GrantVO> paths = ramGrantPolicyMapper.findByPage(filter.getEq(), filter);
        return PageData.data(total, paths);
    }
}
