package com.digiwin.dap.middle.ram.constant;

/**
 * Cache缓存名
 *
 * @author fobgochod
 * @date 2021/8/19 15:39
 */
public interface CacheConstant {

    String RAM_GRANT = "ram:grant:";
    String RAM_POLICY = "ram:policy:";
    String RAM_ROUTE = "ram:route:";

    /**
     * 应用
     */
    String ROUTE_APP = "%s:ram:route:%s";
    /**
     * 应用:策略类型
     */
    String POLICY_TYPE = "%s:ram:policy:%s:%s";
    /**
     * 应用:策略ID
     */
    String POLICY_ID = "%s:ram:policy:%s:%s";
    /**
     * 应用:{方法 路由}
     */
    String POLICY_PATH = "%s:ram:policy:%s:{%s %s}";
    /**
     * 应用:目标类型:目标ID
     */
    String GRANT_TARGET = "%s:ram:grant:%s:%s:%s";

    static String getRouteApp(String prefix, String app) {
        return String.format(ROUTE_APP, prefix, app);
    }

    static String getPolicyType(String prefix, String app, String policyType) {
        return String.format(POLICY_TYPE, prefix, app, policyType);
    }

    static String getPolicyId(String prefix, String app, String policyId) {
        return String.format(POLICY_ID, prefix, app, policyId);
    }

    static String getPolicyPath(String prefix, String app, String method, String path) {
        return String.format(POLICY_PATH, prefix, app, method, path);
    }

    static String getGrantTarget(String prefix, String app, String targetType, String targetId) {
        return String.format(GRANT_TARGET, prefix, app, targetType, targetId);
    }
}
