package com.digiwin.dap.middle.ram.domain;

import com.digiwin.dap.middleware.commons.util.StrUtils;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 路由清单
 *
 * @author fobgochod
 * @date 2021/8/16 16:42
 */
public class RouteVO {

    private Long sid;
    private String app;
    private String name;
    private String method;
    private String path;
    private String tableName;
    private String remark;
    private Boolean effect;
    private LocalDateTime createDate;
    private LocalDateTime attachDate;
    private Integer useCount;

    private Long policyRouteSid;
    private String policyId;
    private String policyName;
    private String policyType;
    private List<String> policyTypes;

    public Long getSid() {
        return sid;
    }

    public void setSid(Long sid) {
        this.sid = sid;
    }

    public String getApp() {
        return app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Boolean getEffect() {
        return effect;
    }

    public void setEffect(Boolean effect) {
        this.effect = effect;
    }

    public LocalDateTime getCreateDate() {
        return createDate;
    }

    public void setCreateDate(LocalDateTime createDate) {
        this.createDate = createDate;
    }

    public LocalDateTime getAttachDate() {
        return attachDate;
    }

    public void setAttachDate(LocalDateTime attachDate) {
        this.attachDate = attachDate;
    }

    public Integer getUseCount() {
        return useCount;
    }

    public void setUseCount(Integer useCount) {
        this.useCount = useCount;
    }

    public String getPolicyId() {
        return policyId;
    }

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    public String getPolicyName() {
        return policyName;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public String getPolicyType() {
        return policyType;
    }

    public void setPolicyType(String policyType) {
        this.policyType = policyType;
    }

    public Long getPolicyRouteSid() {
        return policyRouteSid;
    }

    public void setPolicyRouteSid(Long policyRouteSid) {
        this.policyRouteSid = policyRouteSid;
    }

    public List<String> getPolicyTypes() {
        return policyTypes;
    }

    public void setPolicyTypes(List<String> policyTypes) {
        this.policyTypes = policyTypes;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        if (StrUtils.hasText(method)) {
            builder.append(method).append(" ");
        }
        builder.append(path);
        builder.append('}');
        return builder.toString();
    }
}
