package com.digiwin.dap.middle.ram.mapper;

import com.digiwin.dap.middle.ram.domain.GrantVO;
import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.PolicyVO;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface RamExecutorMapper {

    List<PatternVO> findRouteByApp(@Param("app") String app);

    List<PatternVO> findPolicyByType(@Param("app") String app, @Param("policyType") String policyType);

    List<PatternVO> findPolicyById(@Param("app") String app, @Param("policyId") String policyId);

    List<PolicyVO> findPolicyIdByTarget(@Param("app") String app, @Param("targetType") String targetType, @Param("targetId") String targetId);

    List<PolicyVO> findPolicyIdByPath(@Param("app") String app, @Param("method") String method, @Param("path") String path);

    List<GrantVO> findTargetByPolicyId(@Param("app") String app, @Param("targetType") String targetType, @Param("policyId") String policyId);
}
