package com.digiwin.dap.middle.ram.mapper;

import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.RouteVO;
import com.digiwin.dap.middle.ram.domain.page.Filter;
import com.digiwin.dap.middle.ram.entity.PolicyRoute;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface RamPolicyRouteMapper {

    int insert(@Param("entity") PolicyRoute entity);

    int deleteBySid(@Param("sid") long sid);

    int update(@Param("entity") PolicyRoute entity);

    PolicyRoute findBySid(@Param("sid") long sid);

    boolean exists(@Param("policySid") long policySid, @Param("routeSid") long routeSid);

    int deleteByPolicySid(@Param("policySid") long policySid);

    List<PolicyVO> findByRouteSid(@Param("routeSid") long routeSid);

    List<RouteVO> findByPolicySid(@Param("policySid") long policySid);

    long countByPage(@Param("cond") RouteVO cond, @Param("filter") Filter<?> filter);

    List<RouteVO> findByPage(@Param("cond") RouteVO cond, @Param("filter") Filter<?> filter);
}
