package com.digiwin.dap.middle.ram.mapper;

import com.digiwin.dap.middle.ram.domain.RouteVO;
import com.digiwin.dap.middle.ram.domain.page.Filter;
import com.digiwin.dap.middle.ram.entity.Route;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface RamRouteMapper {

    int insert(@Param("entity") Route entity);

    int deleteBySid(@Param("sid") long sid);

    int update(@Param("entity") Route entity);

    Route findBySid(@Param("sid") long sid);

    boolean existsBySid(@Param("sid") long sid);

    long countByPage(@Param("cond") Route cond, @Param("filter") Filter<?> filter);

    List<RouteVO> findByPage(@Param("cond") Route cond, @Param("filter") Filter<?> filter);

    List<Route> findByCond(@Param("cond") Route cond);

    List<Route> findAll();
}
