package com.digiwin.dap.middle.ram.service.access;

import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.service.access.policy.PolicyFilterHandler;
import com.digiwin.dap.middleware.auth.domain.RequestInfo;

import java.util.List;

/**
 * 按照顺序执行 {@link TargetType}
 *
 * @author fobgochod
 * @date 2021/9/18 17:58
 */
public final class TargetTypeChain {

    private final List<TargetInfo> targetTypes;
    private final int size;
    private final PolicyFilterHandler policyFilterHandler;
    private int currentPosition = 0;

    private TargetTypeChain(PolicyFilterHandler policyFilterHandler, List<TargetInfo> targetTypes) {
        this.policyFilterHandler = policyFilterHandler;
        this.targetTypes = targetTypes;
        this.size = targetTypes.size();
    }

    public static TargetTypeChain getInstance(PolicyFilterHandler policyHandler, List<TargetInfo> targetTypes) {
        return new TargetTypeChain(policyHandler, targetTypes);
    }

    public ResultType matches(RequestInfo request) {
        if (currentPosition == size) {
            return ResultType.IMPLICIT_DENY;
        } else {
            currentPosition++;

            TargetInfo nextTarget = targetTypes.get(currentPosition - 1);

            ResultType resultType = policyFilterHandler.matches(nextTarget.getTargetType().name(), nextTarget.getTargetId(), request);
            if (ResultType.IMPLICIT_DENY == resultType) {
                return matches(request);
            } else {
                return resultType;
            }
        }
    }
}
