package com.digiwin.dap.middle.ram.service.authentication.handler;

import com.digiwin.dap.middle.ram.service.authentication.AuthCheckHandler;
import com.digiwin.dap.middle.ram.service.authentication.AuthCheckService;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;
import com.digiwin.dap.middleware.auth.domain.RequestInfo;
import org.springframework.core.annotation.Order;

/**
 * 调用CAC查询授权信息，授权结果{@link AuthType}
 *
 * @author fobgochod
 * @date 2022/4/11 15:04
 */
@Order(10)
public class DoAuthCheckHandler extends AuthCheckHandler {

    private final AuthCheckService authCheckService;

    public DoAuthCheckHandler(AuthCheckService authCheckService) {
        this.authCheckService = authCheckService;
    }

    @Override
    public AuthResult processAuth(AuthResult authResult, AuthoredUser user, AuthoredSys sys, RequestInfo request) {
        return authCheckService.processAuth(authResult, user, sys);
    }
}
