package com.digiwin.dap.middle.ram.service.executor;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;

import java.util.List;

public interface PolicyExecutor {

    /**
     * 获取特定策略类型下的路由配置信息
     *
     * @param app        应用ID
     * @param policyType {@link PolicyType#None}、{@link PolicyType#AllowList}、{@link PolicyType#NoAuth}
     */
    List<PatternVO> findRouteByPolicyType(String app, String policyType);

    /**
     * 根据策略ID获取路由配置信息
     *
     * @param app      应用ID
     * @param policyId 策略ID
     */
    List<PatternVO> findRouteByPolicyId(String app, String policyId);

    /**
     * 通过方法和路由查询策略ID
     *
     * @param app    应用ID
     * @param method 方法
     * @param path   路由
     * @return 策略ID
     */
    List<PolicyVO> findPolicyIdByRoute(String app, String method, String path);
}

