/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.filter;

import com.digiwin.dap.middle.ram.service.authentication.AuthCheckHandler;
import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;
import com.digiwin.dap.middleware.constant.InternalUrl;
import com.digiwin.dap.middleware.domain.FilterOrderEnum;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.Ordered;
import org.springframework.web.filter.OncePerRequestFilter;

public class AuthCheckFilter
extends OncePerRequestFilter
implements Ordered {
    private final AuthCheckHandler authCheckHandler;

    public AuthCheckFilter(AuthCheckHandler authCheckHandler) {
        this.authCheckHandler = authCheckHandler;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (InternalUrl.authAllows().get(request.getRequestURI()) == null) {
            AppAuthContext context = AppAuthContextHolder.getContext();
            AuthResult authResult = this.authCheckHandler.processAuth(AuthResult.of(), context.getAuthoredUser(), context.getAuthoredSys(), context.getRequestInfo());
            AuthType.checkAuthResult((AuthType)authResult.getAuthType(), (AuthoredUser)context.getAuthoredUser(), (AuthoredSys)context.getAuthoredSys());
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public int getOrder() {
        return FilterOrderEnum.APP_CHECK.order();
    }
}

