package com.digiwin.dap.middle.stream.domain;

/**
 * 外部应用通知类型，具体参考表sys_notice_type数据
 *
 * @author fobgochod
 * @date 2023/4/17 11:33
 */
public enum SysNoticeEnum {

    /**
     * 初始化
     */
    APP_NEW,
    /**
     * 续期
     */
    APP_RENEW,
    /**
     * 过期通知
     */
    APP_EXPIRED,
    /**
     * 加购
     */
    APP_ADD_PURCHASE,
    /**
     * 用户加入租户
     */
    APP_USER_JOINED,
    /**
     * 包月排程开通通知
     */
    APP_MONTHLY,

    /**********************************************/
    /*         特殊的事件，不属于应用通知流程           */
    /**********************************************/

    /**
     * 服务类商品初始化，地址还是配置在goods的backUri
     */
    SERVICE_NEW("/salesOrder/api/app/initialize"),
    /**
     * 应用初始化、续约失败后，通知订单、授权更新相关状态
     */
    APP_CALLBACK("/api/omc/v2/orders/initialize/update"),

    /**
     * 停用eoc员工
     */
    EMP_DISABLE("/api/app/tenant/emp/disabled"),
    ;

    private String path;

    SysNoticeEnum() {
    }

    SysNoticeEnum(String path) {
        this.path = path;
    }

    public String path() {
        return path;
    }
}
