/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.stream.producer.impl;

import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.stream.domain.MessageType;
import com.digiwin.dap.middle.stream.producer.ProducerService;
import com.digiwin.dap.middle.stream.producer.channel.MsgOutput;
import com.digiwin.dap.middle.stream.producer.channel.SysOutput;
import com.digiwin.dap.middleware.constant.DapHttpHeaders;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class ProducerServiceImpl
implements ProducerService {
    @Autowired
    private DapEnv dapEnv;
    @Autowired
    private MsgOutput msgChannel;
    @Autowired(required=false)
    private SysOutput sysChannel;
    @Autowired
    private ThreadPoolTaskExecutor dapTaskExecutor;

    @Override
    public void msg(MessageBody messageBody) {
        String payload;
        messageBody.setSourceId(this.dapEnv.getAppName());
        messageBody.setMsgType(MessageType.MSG);
        if (messageBody.getUserToken() == null) {
            messageBody.setUserToken(UserUtils.getToken());
        }
        if ((payload = JsonUtils.writeValue((Object)messageBody)) == null) {
            return;
        }
        Message message = MessageBuilder.withPayload((Object)payload).setHeader(DapHttpHeaders.MESSAGE_EVENT_ID.getHeader(), (Object)messageBody.getOpType()).setHeader(DapHttpHeaders.USER_TOKEN.getHeader(), (Object)messageBody.getUserToken()).setHeader(DapHttpHeaders.APP_TOKEN.getHeader(), (Object)"eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE1MzczMjY2ODk0NjEsInNpZCI6NDA3MTI4ODI1NTM0NDY0MSwiaWQiOiJEaWdpd2luQ2xvdWQifQ.XGPl3brNeNTCivWN_bIYj8TfcxqlkQ0sFV2woPOr0TY").setHeader(DapHttpHeaders.ACCEPT_LANGUAGE.getHeader(), (Object)LocaleContextHolder.getLocale().toLanguageTag()).setHeader("userId", (Object)UserUtils.getUserId()).setHeader("tenantId", (Object)UserUtils.getTenantId()).setHeader("target", (Object)"emc").build();
        this.dapTaskExecutor.execute(() -> this.msgChannel.msg().send(message));
    }

    @Override
    public void sys(MessageBody messageBody) {
        String payload;
        messageBody.setSourceId(this.dapEnv.getAppName());
        messageBody.setMsgType(MessageType.SYS);
        if (messageBody.getUserToken() == null) {
            messageBody.setUserToken(UserUtils.getToken());
        }
        if ((payload = JsonUtils.writeValue((Object)messageBody)) == null) {
            return;
        }
        Message message = MessageBuilder.withPayload((Object)payload).setHeader(DapHttpHeaders.USER_TOKEN.getHeader(), (Object)messageBody.getUserToken()).setHeader(DapHttpHeaders.APP_TOKEN.getHeader(), (Object)"eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE1MzczMjY2ODk0NjEsInNpZCI6NDA3MTI4ODI1NTM0NDY0MSwiaWQiOiJEaWdpd2luQ2xvdWQifQ.XGPl3brNeNTCivWN_bIYj8TfcxqlkQ0sFV2woPOr0TY").setHeader(DapHttpHeaders.ACCEPT_LANGUAGE.getHeader(), (Object)LocaleContextHolder.getLocale().toLanguageTag()).build();
        this.dapTaskExecutor.execute(() -> this.sysChannel.sys().send(message));
    }
}

