package com.digiwin.dap.middle.stream.producer.impl;

import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.stream.domain.MessageType;
import com.digiwin.dap.middle.stream.producer.ProducerService;
import com.digiwin.dap.middle.stream.producer.channel.MsgOutput;
import com.digiwin.dap.middle.stream.producer.channel.SysOutput;
import com.digiwin.dap.middleware.constant.DapHttpHeaders;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class ProducerServiceImpl implements ProducerService {

    @Autowired
    private DapEnv dapEnv;
    @Autowired
    private MsgOutput msgChannel;
    @Autowired(required = false)
    private SysOutput sysChannel;
    @Autowired
    private ThreadPoolTaskExecutor dapTaskExecutor;

    @Override
    public void msg(MessageBody messageBody) {
        messageBody.setSourceId(dapEnv.getAppName());
        messageBody.setMsgType(MessageType.MSG);
        if (messageBody.getUserToken() == null) {
            messageBody.setUserToken(UserUtils.getToken());
        }
        String payload = JsonUtils.writeValue(messageBody);
        if (payload == null) {
            return;
        }
        Message<?> message = MessageBuilder.withPayload(payload)
                .setHeader(DapHttpHeaders.MESSAGE_EVENT_ID.getHeader(), messageBody.getOpType())
                .setHeader(DapHttpHeaders.USER_TOKEN.getHeader(), messageBody.getUserToken())
                .setHeader(DapHttpHeaders.APP_TOKEN.getHeader(), GlobalConstants.DigiwinCloud_APP_TOKEN)
                .setHeader(DapHttpHeaders.ACCEPT_LANGUAGE.getHeader(), LocaleContextHolder.getLocale().toLanguageTag())
                .setHeader("userId", UserUtils.getUserId())
                .setHeader("tenantId", UserUtils.getTenantId())
                .setHeader("target", "emc")
                .build();
        dapTaskExecutor.execute(() -> msgChannel.msg().send(message));
    }

    @Override
    public void sys(MessageBody messageBody) {
        messageBody.setSourceId(dapEnv.getAppName());
        messageBody.setMsgType(MessageType.SYS);
        if (messageBody.getUserToken() == null) {
            messageBody.setUserToken(UserUtils.getToken());
        }
        String payload = JsonUtils.writeValue(messageBody);
        if (payload == null) {
            return;
        }
        Message<?> message = MessageBuilder.withPayload(payload)
                .setHeader(DapHttpHeaders.USER_TOKEN.getHeader(), messageBody.getUserToken())
                .setHeader(DapHttpHeaders.APP_TOKEN.getHeader(), GlobalConstants.DigiwinCloud_APP_TOKEN)
                .setHeader(DapHttpHeaders.ACCEPT_LANGUAGE.getHeader(), LocaleContextHolder.getLocale().toLanguageTag())
                .build();
        dapTaskExecutor.execute(() -> sysChannel.sys().send(message));
    }
}
