package com.digiwin.dap.middle.stream.producer.config;

import com.digiwin.dap.middle.stream.condition.KanbanOutputCondition;
import com.digiwin.dap.middle.stream.condition.SysOutputCondition;
import com.digiwin.dap.middle.stream.producer.channel.*;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableBinding(MsgOutput.class)
public class ProducerConfig {

    @EnableBinding(SysOutput.class)
    @Conditional(SysOutputCondition.class)
    static class SysBinding {
    }

    @EnableBinding(SocketOutput.class)
    @ConditionalOnProperty(prefix = "spring.application", name = "name", havingValue = "emc")
    static class SocketBinding {
    }

    @EnableBinding(KanbanOutput.class)
    @Conditional(KanbanOutputCondition.class)
    static class KanbanBinding {
    }

    @EnableBinding(InternalOutput.class)
    static class internalBinding {
    }
}
