package com.digiwin.dap.middle.stream.domain;

/**
 * 外部应用通知类型，具体参考表sys_notice_type数据
 *
 * @author fobgochod
 * @date 2023/4/17 11:33
 */
public enum SysNoticeEnum {

    /**
     * 初始化
     */
    APP_NEW("/api/app/initialize"),
    /**
     * 续期
     */
    APP_RENEW("/api/app/tenant/renew/notices"),
    /**
     * 过期通知
     */
    APP_EXPIRED("/api/app/tenant/expired/notices"),
    /**
     * 加购
     */
    APP_ADD_PURCHASE("/api/app/tenant/add/purchase/notices"),
    /**
     * 用户加入租户
     */
    APP_USER_JOINED("/api/app/tenant/user/joined"),
    /**
     * 包月排程开通通知
     */
    APP_MONTHLY("/api/app/monthly"),

    /**
     * 停用eoc员工
     */
    EMP_DISABLE("/api/app/tenant/emp/disabled"),

    /**
     * 授权用户
     */
    AUTH_USER("/api/app/user/auth/notice"),

    /**
     * 删除公司、工厂
     */
    DELETE_CORP("/api/app/tenant/corp/deleted"),

    /**
     * 组合商品初始化
     */
    APP_PACK_NEW("/api/app/tenant/purchase/pack"),

    /**********************************************/
    /*         特殊的事件，不属于应用通知流程           */
    /**********************************************/

    /**
     * 服务类商品初始化，地址还是配置在goods的backUri
     */
    SERVICE_NEW("/salesOrder/api/app/initialize"),
    /**
     * 应用初始化、续约失败后，通知订单、授权更新相关状态
     */
    APP_CALLBACK("/api/omc/v2/orders/initialize/update"),
    ;

    private String path;

    SysNoticeEnum() {
    }

    SysNoticeEnum(String path) {
        this.path = path;
    }

    public String path() {
        return path;
    }
}
