package com.digiwin.dap.middle.stream.consumer.config;

import com.digiwin.dap.middle.stream.consumer.channel.MsgInput;
import com.digiwin.dap.middle.stream.consumer.channel.SysInput;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ConsumerConfig {

    @EnableBinding(SysInput.class)
    @ConditionalOnProperty(prefix = "spring.application", name = "name", havingValue = "iam")
    static class SysBinding {
    }

    @EnableBinding(MsgInput.class)
    @ConditionalOnProperty(prefix = "spring.application", name = "name", havingValue = "emc")
    static class MsgBinding {
    }
}
