package com.digiwin.dap.middle.stream.domain;

public class MessageBody {

    /**
     * 消息来源，比如IAM、OMC等
     */
    private String sourceId;
    /**
     * 通知类别
     */
    private MessageType msgType;
    /**
     * 消息发送人token
     */
    private String userToken;
    /**
     * EMC：指具体的事件ID
     * 应用：具体的通知类型
     */
    private String opType;
    /**
     * 消费时候实际需要的数据
     */
    private Object data;
    /**
     * 消息消费状态
     */
    private boolean success;
    /**
     * 是否需要短信、邮件通知
     */
    private boolean needMsg;
    /**
     * 消息消费结果
     */
    private String message;
    /**
     * 租户SID
     */
    private Long tenantSid;
    /**
     * 租户ID
     */
    private String tenantId;
    /**
     * 应用ID
     */
    private String sysId;
    /**
     * 应用地址
     * 比如 service类商品，地址存储在商品上面，通过消息主动指定这个地址，优先级最高
     */
    private String backUri;
    /**
     * 回调地址
     */
    private String noticeUri;
    /**
     * 回调数据
     */
    private Object noticeData;

    public MessageBody() {
    }

    public MessageBody(String opType) {
        this.opType = opType;
    }

    public MessageBody(String opType, Object data) {
        this.opType = opType;
        this.data = data;
    }

    public static MessageBody of(String opType) {
        return new MessageBody(opType);
    }

    public static MessageBody of(String opType, Object data) {
        return new MessageBody(opType, data);
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public MessageType getMsgType() {
        return msgType;
    }

    public void setMsgType(MessageType msgType) {
        this.msgType = msgType;
    }

    public String getUserToken() {
        return userToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public String getOpType() {
        return opType;
    }

    public void setOpType(String opType) {
        this.opType = opType;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean isNeedMsg() {
        return needMsg;
    }

    public void setNeedMsg(boolean needMsg) {
        this.needMsg = needMsg;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Long getTenantSid() {
        return tenantSid;
    }

    public void setTenantSid(Long tenantSid) {
        this.tenantSid = tenantSid;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getSysId() {
        return sysId;
    }

    public void setSysId(String sysId) {
        this.sysId = sysId;
    }

    public String getBackUri() {
        return backUri;
    }

    public void setBackUri(String backUri) {
        this.backUri = backUri;
    }

    public String getNoticeUri() {
        return noticeUri;
    }

    public void setNoticeUri(String noticeUri) {
        this.noticeUri = noticeUri;
    }

    public Object getNoticeData() {
        return noticeData;
    }

    public void setNoticeData(Object noticeData) {
        this.noticeData = noticeData;
    }
}
