package com.digiwin.dap.middleware.dmc;

import com.digiwin.dap.middleware.dmc.internal.DMCConfig;

/**
 * Fluent builder for OSS Client. Use of the builder is preferred over using
 * constructors of the client class.
 *
 * @author zhouxiao
 * @date 2021/4/23
 */
public interface DMCBuilder {

    /**
     * create a new {@link DMCClient} instance.
     *
     * @return {@link DMCClient} instance
     */
    static DMCBuilder create() {
        return new DMCClientBuilder();
    }

    /**
     * create a new {@link DMCClient} instance.
     * 兼容：使用旧版配置信息 {@link com.digiwin.dmc.sdk.config.ServerSetting}
     *
     * @return {@link DMCClient} instance
     */
    @Deprecated
    DMC build();

    /**
     * Uses the specified tenantId to create a new {@link DMCClient} instance.
     * 兼容：使用旧版配置信息 {@link com.digiwin.dmc.sdk.config.ServerSetting}
     *
     * @param tenantId IAM tenantId
     * @return {@link DMCClient} instance
     */
    @Deprecated
    DMC build(String tenantId);

    /**
     * Uses the specified tenantId to flush the specified client instance.
     * 可以使用 client.switchTenantId(tenantId); 切换
     *
     * @param tenantId IAM tenantId
     * @return {@link DMCClient} instance
     */
    @Deprecated
    DMC build(DMC client, String tenantId);

    /**
     * Uses the parameters to create a new {@link DMCClient} instance.
     *
     * @param uri      DMC server uri
     * @param username DMC username
     * @param password DMC user password
     * @param bucket   DMC database
     * @return {@link DMCClient} instance
     */
    DMC build(String uri, String username, String password, String bucket);

    /**
     * Uses the specified tenantId to create a new {@link DMCClient} instance.
     *
     * @param uri      DMC server uri
     * @param username DMC username
     * @param password DMC user password
     * @param tenantId IAM tenantId
     * @param bucket   DMC database
     * @return {@link DMCClient} instance
     */
    DMC build(String uri, String username, String password, String tenantId, String bucket);

    /**
     * Uses the DMCConfig to create a new {@link DMCClient} instance.
     *
     * @param config 基础配置信息
     * @return {@link DMCClient} instance
     */
    DMC build(DMCConfig config);

    /**
     * Uses the DMCConfig to create a new {@link DMCClient} instance.
     *
     * @param config       基础配置信息
     * @param clientConfig Client configurations for accessing to DMC services
     * @return {@link DMCClient} instance
     */
    DMC build(DMCConfig config, ClientConfiguration clientConfig);
}
