package com.digiwin.dap.middleware.dmc.common.auth;

import com.digiwin.dap.middleware.dmc.internal.DMCUtils;
import com.digiwin.dap.middleware.dmc.internal.operation.DMCLoginOperation;
import com.digiwin.dmc.sdk.util.JwtUtil;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Provides access to credentials used for accessing DMC, these credentials are
 * used to securely sign requests to DMC.
 *
 * @author zhouxiao
 * @date 2021/4/20
 */
public class AuthCache {

    private final Map<String, String> tokenMap = new ConcurrentHashMap<>();
    private DMCLoginOperation loginOperation;

    public void setLoginOperation(DMCLoginOperation loginOperation) {
        this.loginOperation = loginOperation;
    }

    public void addToken(String tenantId, String token) {
        tokenMap.put(tenantId, token);
    }

    public String getToken(String tenantId) {
        String token = tokenMap.get(tenantId);
        if (token == null || JwtUtil.isExpires(token)) {
            try {
                return loginOperation.login(tenantId);
            } catch (Exception e) {
                throw new InvalidTokenException(DMCUtils.DMC_RESOURCE_MANAGER.getFormattedString("LoginError", e.getMessage()), e);
            }
        }
        return token;
    }

    public void removeToken(String tenantId) {
        tokenMap.remove(tenantId);
    }

    public void clear() {
        tokenMap.clear();
    }
}
