package com.digiwin.dap.middleware.dmc.internal.operation;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.internal.DMCOperation;
import com.digiwin.dap.middleware.dmc.internal.DMCRequestMessageBuilder;
import com.digiwin.dap.middleware.dmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.dmc.model.DirInfo;
import com.digiwin.dap.middleware.dmc.model.DirRequest;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.dap.middleware.dmc.model.FileInfoRequest;

/**
 * 目录
 *
 * @author zhouxiao
 * @date 2021/5/10
 */
public class DMCBaseOperation extends DMCOperation {

    public DMCBaseOperation(ServiceClient client) {
        super(client);
    }

    public DirInfo addDirInfo(DirRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getDirInfoAddUrl())
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setOriginalRequest(original)
                .build();
        return doOperation(request, ResponseParsers.dirInfoResponseParser);
    }

    public DirInfo modDirInfo(DirRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getDirInfoModUrl())
                .setMethod(HttpMethod.PUT)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setOriginalRequest(original)
                .build();
        return doOperation(request, ResponseParsers.dirInfoResponseParser);
    }

    public DirInfo getDirInfo(DirRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getDirInfoGetUrl(original.getDirId()))
                .setMethod(HttpMethod.GET)
                .setHeaders(original.getHeaders())
                .setOriginalRequest(original)
                .build();
        return doOperation(request, ResponseParsers.dirInfoResponseParser);
    }

    public DirInfo getDirInfoByName(DirRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getDirInfoGetByNameUrl(original.getDirInfo().getParentId(), original.getDirInfo().getName()))
                .setMethod(HttpMethod.GET)
                .setHeaders(original.getHeaders())
                .setOriginalRequest(original)
                .build();
        return doOperation(request, ResponseParsers.dirInfoResponseParser);
    }

    public FileInfo modFileInfo(FileInfoRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getFileInfoModUrl())
                .setMethod(HttpMethod.PUT)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setOriginalRequest(original)
                .build();
        return doOperation(request, ResponseParsers.fileInfoResponseParser);
    }

    public FileInfo getFileInfo(FileInfoRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getFileInfoGetUrl(original.getFileId()))
                .setMethod(HttpMethod.GET)
                .setHeaders(original.getHeaders())
                .setOriginalRequest(original)
                .build();
        return doOperation(request, ResponseParsers.fileInfoResponseParser);
    }
}


