package com.digiwin.dap.middleware.dmc.internal.operation;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.internal.DMCOperation;
import com.digiwin.dap.middleware.dmc.internal.DMCRequestMessageBuilder;
import com.digiwin.dap.middleware.dmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.dmc.model.FileOpRequest;

/**
 * 剪切
 *
 * @author zhouxiao
 * @date 2021/5/7
 */
public class DMCMoveOperation extends DMCOperation {

    public DMCMoveOperation(ServiceClient client) {
        super(client);
    }

    public void move(FileOpRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getMoveUrl(original.getFileId(), original.getTargetDirId()))
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setOriginalRequest(original)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }

    public void moveDir(FileOpRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getMoveDirUrl(original.getDirId(), original.getTargetDirId()))
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setOriginalRequest(original)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }

    public void moveMulti(FileOpRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getMoveMultiUrl(original.getTargetDirId()))
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setOriginalRequest(original)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }
}


