package com.digiwin.dap.middleware.dmc.model;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

/**
 * file info
 *
 * @author zhouxiao
 * @date 2021/4/25
 */
public class FileInfo extends BaseEntity {

    private String fileName;
    private String displayName;
    private String description;
    private String tag;
    private long size;
    private String extension;
    private String contentType;
    private LocalDateTime expireDate;
    private String directoryId;
    private Map<String, Object> metadata = new HashMap<>();

    public FileInfo() {
    }

    public FileInfo(String fileName) {
        this.fileName = fileName;
    }

    public FileInfo(String fileName, String directoryId) {
        this.fileName = fileName;
        this.directoryId = directoryId;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public long getSize() {
        return size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public LocalDateTime getExpireDate() {
        return expireDate;
    }

    public void setExpireDate(LocalDateTime expireDate) {
        this.expireDate = expireDate;
    }

    public String getDirectoryId() {
        return directoryId;
    }

    public void setDirectoryId(String directoryId) {
        this.directoryId = directoryId;
    }

    public Map<String, Object> getMetadata() {
        return metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    @Override
    public String toString() {
        return "{"
                + "\"fileName\":\""
                + fileName + '\"'
                + ",\"displayName\":\""
                + displayName + '\"'
                + ",\"description\":\""
                + description + '\"'
                + ",\"tag\":\""
                + tag + '\"'
                + ",\"size\":"
                + size
                + ",\"extension\":\""
                + extension + '\"'
                + ",\"contentType\":\""
                + contentType + '\"'
                + ",\"expireDate\":"
                + expireDate
                + ",\"directoryId\":\""
                + directoryId + '\"'
                + ",\"metadata\":"
                + metadata
                + ",\"super\":" + super.toString() + "}";
    }
}
