package com.digiwin.dmc.sdk.service;

import com.digiwin.dmc.sdk.entity.BucketInfo;

import java.util.List;

/**
 * 存储区管理
 */
public interface IBucketManagerService {
    /**
     * 创建存储区
     *
     * @param bucketInfo
     * @return
     */
    String createBucket(BucketInfo bucketInfo);

    /**
     * 获取存储区
     *
     * @return
     */
    List<BucketInfo> getBuckets();

    /**
     * 判断bucket是否存在
     *
     * @return
     */
    String isExistBucket(String bucketName);

    /**
     * 创建存储区-多租户
     *
     * @param bucketInfo
     * @return
     */
    @Deprecated
    String createBucketByTenant(String tenantId, BucketInfo bucketInfo);

    /**
     * 判断bucket是否存在-多租户
     *
     * @return
     */
    @Deprecated
    String isExistBucketByTenant(String tenantId, String bucketName);
}
