package com.digiwin.dmc.sdk.service;

import com.digiwin.dmc.sdk.entity.ImageCacheFile;

import java.util.List;

@Deprecated
public interface IHandleImageService {
    /**
     * 图片缩放，按比例
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param scale      原图的百分比 0--100
     * @param driveToken 操作token
     */
    byte[] dealImagePng(String bucketName, String fileId, int scale, String driveToken);

    byte[] dealImagePng(String bucketName, String fileId, int scale);

    byte[] dealImagePng(String fileId, int scale);

    /**
     * 图片缩放，按比例，圆角处理
     *
     * @param bucketName   存储区
     * @param fileId       文件id
     * @param scale        原图的百分比 0--100
     * @param cornerRadius 圆角半径
     * @param driveToken   操作token
     */
    byte[] dealImageRound(String bucketName, String fileId, int scale, int cornerRadius, String driveToken);

    byte[] dealImageRound(String bucketName, String fileId, int scale, int cornerRadius);

    byte[] dealImageRound(String fileId, int scale, int cornerRadius);


    /**
     * 图片缩放，按比例，自定义输出图片格式
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param scale      原图的百分比 0--100
     * @param format     图片格式
     * @param driveToken 操作token
     */
    byte[] dealImage(String bucketName, String fileId, int scale, String format, String driveToken);
    byte[] dealImage(String bucketName, String fileId, int scale, String format);
    byte[] dealImage(String fileId, int scale, String format);

    /**
     * 图片缩放，高根据宽自适应
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param width      宽
     * @param driveToken 操作token
     */
    byte[] dealImageSetWidth(String bucketName, String fileId, int width, String driveToken);
    byte[] dealImageSetWidth(String bucketName, String fileId, int width);
    byte[] dealImageSetWidth(String fileId, int width);


    /**
     * 图片缩放，高根据宽自适应，圆角处理
     *
     * @param bucketName   存储区
     * @param fileId       文件id
     * @param width        宽
     * @param cornerRadius 圆角大小
     * @param driveToken   操作token
     */
    byte[] dealImageSetWidthRound(String bucketName, String fileId, int width, int cornerRadius, String driveToken);
    byte[] dealImageSetWidthRound(String bucketName, String fileId, int width, int cornerRadius);
    byte[] dealImageSetWidthRound(String fileId, int width, int cornerRadius);

    /**
     * 图片缩放，高根据宽自适应，自定义格式
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param width      宽
     * @param format 图片格式
     * @param driveToken   操作token
     */
    byte[] dealImageSetWidthFormat(String bucketName, String fileId, int width, String format, String driveToken);
    byte[] dealImageSetWidthFormat(String bucketName, String fileId, int width, String format );
    byte[] dealImageSetWidthFormat(String fileId, int width, String format );

    /**
     * 图片缩放，宽根据高自适应
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param height      宽
     * @param driveToken 操作token
     */
    byte[] dealImageSetHeight(String bucketName, String fileId, int height, String driveToken);
    byte[] dealImageSetHeight(String bucketName, String fileId, int height);
    byte[] dealImageSetHeight(String fileId, int height);


    /**
     * 图片缩放，宽根据高自适应，圆角处理
     *
     * @param bucketName   存储区
     * @param fileId       文件id
     * @param height        高
     * @param cornerRadius 圆角大小
     * @param driveToken   操作token
     */
    byte[] dealImageSetHeightRound(String bucketName, String fileId, int height, int cornerRadius, String driveToken);
    byte[] dealImageSetHeightRound(String bucketName, String fileId, int height, int cornerRadius);
    byte[] dealImageSetHeightRound(String fileId, int height, int cornerRadius);

    /**
     * 图片缩放，宽根据高自适应，自定义格式
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param height      高
     * @param format 图片格式
     * @param driveToken   操作token
     */
    byte[] dealImageSetHeightFormat(String bucketName, String fileId, int height, String format, String driveToken);
    byte[] dealImageSetHeightFormat(String bucketName, String fileId, int height, String format );
    byte[] dealImageSetHeightFormat(String fileId, int height, String format );

    /**
     * 图片缩放,居中剪裁,默认png,设置宽高
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param width      宽
     * @param height     高
     * @param driveToken 操作token
     */
    byte[] dealImageClipPng(String bucketName, String fileId,int width, int height, String driveToken);
    byte[] dealImageClipPng(String bucketName, String fileId, int width, int height);
    byte[] dealImageClipPng(String fileId, int width, int height);

    /**
     * 图片缩放,居中剪裁,默认png,设置宽高，圆角处理
     *
     * @param bucketName   存储区
     * @param fileId       文件id
     * @param width        宽
     * @param height       高
     * @param cornerRadius 圆角半径
     * @param driveToken 操作token
     */
    byte[] dealImageClipRound(String bucketName, String fileId,int width, int height,int cornerRadius, String driveToken);
    byte[] dealImageClipRound(String bucketName, String fileId,int width, int height,int cornerRadius);
    byte[] dealImageClipRound(String fileId,int width, int height,int cornerRadius);


    /**
     * 图片缩放,居中剪裁，自定义格式
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param width      宽
     * @param height     高
     * @param format     图片输出的格式
     *  @param  driveToken 操作token
     */
    byte[] dealImageClipFormat(String bucketName, String fileId,int width, int height,String format, String driveToken);
    byte[] dealImageClipFormat(String bucketName, String fileId,int width, int height,String format);
    byte[] dealImageClipFormat(String fileId,int width, int height,String format);

    /**
     * 图片缩放,居中剪裁,根据宽生成正方形
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param width      宽
     * @param driveToken 操作token
     */
    byte[] dealImageClipSetWidth(String bucketName, String fileId, int width, String driveToken);
    byte[] dealImageClipSetWidth(String bucketName, String fileId, int width );
    byte[] dealImageClipSetWidth( String fileId, int width );

    /**
     * 图片缩放,居中剪裁,根据宽生成正方形，圆角处理
     *
     * @param bucketName   存储区
     * @param fileId       文件id
     * @param width        宽
     * @param cornerRadius 圆角半径
     * @param driveToken 操作token
     */
    byte[] dealImageClipSetWidthRound(String bucketName, String fileId, int width,int cornerRadius,String driveToken);
    byte[] dealImageClipSetWidthRound(String bucketName, String fileId, int width,int cornerRadius);
    byte[] dealImageClipSetWidthRound(String fileId, int width,int cornerRadius);

    /**
     * 图片缩放,居中剪裁,根据宽生成正方形，自定义格式
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param width      宽
     * @param format 图片格式
     * @param driveToken 操作token
     */
    byte[] dealImageClipSetWidthFormat(String bucketName, String fileId, int width,String format,String driveToken);
    byte[] dealImageClipSetWidthFormat(String bucketName, String fileId, int width,String format );
    byte[] dealImageClipSetWidthFormat(String fileId, int width,String format );











    /**
     * 图片缩放,居中剪裁,根据高生成正方形
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param height      高
     * @param driveToken 操作token
     */
    byte[] dealImageClipSetHeight(String bucketName, String fileId, int height, String driveToken);
    byte[] dealImageClipSetHeight(String bucketName, String fileId, int height );
    byte[] dealImageClipSetHeight( String fileId, int height );

    /**
     * 图片缩放,居中剪裁,根据高生成正方形，圆角处理
     *
     * @param bucketName   存储区
     * @param fileId       文件id
     * @param height        高
     * @param cornerRadius 圆角半径
     * @param driveToken 操作token
     */
    byte[] dealImageClipSetHeightRound(String bucketName, String fileId, int height,int cornerRadius,String driveToken);
    byte[] dealImageClipSetHeightRound(String bucketName, String fileId, int height,int cornerRadius);
    byte[] dealImageClipSetHeightRound(String fileId, int height,int cornerRadius);

    /**
     * 图片缩放,居中剪裁,根据高生成正方形，自定义格式
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param height      高
     * @param format 图片格式
     * @param driveToken 操作token
     */
    byte[] dealImageClipSetHeightFormat(String bucketName, String fileId, int height,String format,String driveToken);
    byte[] dealImageClipSetHeightFormat(String bucketName, String fileId, int height,String format );
    byte[] dealImageClipSetHeightFormat(String fileId, int height,String format );

    /**
     * 处理图片 256*256
     *
     * @param bucketName   存储区
     * @param fileId       图片文件id
     * @param cornerRadius 圆角半径
     * @param driveToken 操作token
     */
    byte[] dealImageLarger(String bucketName, String fileId, int cornerRadius,String driveToken);
    byte[] dealImageLarger(String bucketName, String fileId, int cornerRadius );
    byte[] dealImageLarger(String fileId, int cornerRadius);

    /**
     * 处理图片 64*64
     *
     * @param bucketName   存储区
     * @param fileId       图片文件id
     * @param cornerRadius 圆角半径
     * @param driveToken 操作token
     */
    byte[] dealImageLarge(String bucketName, String fileId, int cornerRadius,String driveToken);
    byte[] dealImageLarge(String bucketName, String fileId, int cornerRadius );
    byte[] dealImageLarge(String fileId, int cornerRadius);

    /**
     * 处理图片 32*32
     *
     * @param bucketName   存储区
     * @param fileId       图片文件id
     * @param cornerRadius 圆角半径
     * @param driveToken 操作token
     */
    byte[] dealImageMiddle(String bucketName, String fileId, int cornerRadius,String driveToken);
    byte[] dealImageMiddle(String bucketName, String fileId, int cornerRadius );
    byte[] dealImageMiddle(String fileId, int cornerRadius);

    /**
     * 处理图片 20*20
     *
     * @param bucketName   存储区
     * @param fileId       图片文件id
     * @param cornerRadius 圆角半径
     * @param driveToken 操作token
     */
    byte[] dealImageSmall(String bucketName, String fileId, int cornerRadius,String driveToken);
    byte[] dealImageSmall(String bucketName, String fileId, int cornerRadius );
    byte[] dealImageSmall(String fileId, int cornerRadius);

    /**
     * 处理图片 16*16
     *
     * @param bucketName   存储区
     * @param fileId       图片文件id
     * @param cornerRadius 圆角半径
     * @param driveToken 操作token
     */
    byte[] dealImageSmaller(String bucketName, String fileId, int cornerRadius,String driveToken);
    byte[] dealImageSmaller(String bucketName, String fileId, int cornerRadius );
    byte[] dealImageSmaller(String fileId, int cornerRadius);

    /**
     * android
     *
     * @param bucketName 存储区
     * @param fileId     图片文件id
     * @param driveToken 操作token
     */
    byte[] dealImageForAndroid(String bucketName, String fileId, String driveToken);
    byte[] dealImageForAndroid(String bucketName, String fileId );
    byte[] dealImageForAndroid(String fileId);

    /**
     * Pad
     *
     * @param bucketName 存储区
     * @param fileId     图片文件id
     * @param driveToken 操作token
     */
    byte[] dealImageForPad(String bucketName, String fileId, String driveToken);
    byte[] dealImageForPad(String bucketName, String fileId );
    byte[] dealImageForPad(String fileId);

    /**
     * ios
     *
     * @param bucketName 存储区
     * @param fileId     图片文件id
     * @param driveToken 操作token
     */
    byte[] dealImageForIos(String bucketName, String fileId, String driveToken);
    byte[] dealImageForIos(String bucketName, String fileId );
    byte[] dealImageForIos(String fileId);

    /**
     * 获取所有缓存
     *
     * @param bucketName 存储区
     * @return List<ImageCacheFile>
     */
     List<ImageCacheFile> findImageCacheFiles(String bucketName);
     List<ImageCacheFile> findImageCacheFiles();
    /**
     * 清除缓存
     *
     * @param bucketName 存储区
     */
    void clean(String bucketName);
    void clean();
}
