package com.digiwin.dmc.sdk.service.download;

import com.digiwin.dmc.sdk.config.DmcUrl;
import com.digiwin.dmc.sdk.config.SDKConstants;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.IUserManagerService;
import com.digiwin.dmc.sdk.service.impl.UserManagerService;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.StringUtil;

import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * @author chenzwd
 * @date : 2018-06-30 16:02
 * @Description:
 */
public class GeneralDocumentDownloader implements IGeneralDocumentDownloader {

    private String fileId;
    private String tenantId;
    private String bucketName;
    private String driveToken;
    private FileOutputStream fileOutputStream;
    private IDownLoadCallbackable completeCallback;
    private DownloadProgressEventArgs eventArgs = new DownloadProgressEventArgs();

    private static ExecutorService es = Executors.newCachedThreadPool();
    private static IUserManagerService userManagerService = UserManagerService.userInstance();

    public GeneralDocumentDownloader(String tenantId, String bucketName, String fileId, String saveToPath, String driveToken) {
        try {
            File file = new File(saveToPath);
            if (!file.exists()) {
                file.createNewFile();
            }
            this.fileOutputStream = new FileOutputStream(file);
        } catch (Exception e) {
            throw new OperateException(e);
        }
        this.fileId = fileId;
        this.tenantId = tenantId;
        this.bucketName = bucketName;
        this.driveToken = driveToken;
        this.eventArgs.setPercentage(0);
        this.eventArgs.setCompletedBytes(0);
    }

    /**
     * 下载Stream中的文件内容，同步模式
     */
    @Override
    public IGeneralDocumentDownloader download() {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String downloadDocumentUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/" + fileId;
        Map<String, String> headers = new HashMap<>();
        if (StringUtil.isEmpty(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        if (tenantId != null){
            headers.put(SDKConstants.HTTP_HEADER_TENANTID_KEY, tenantId);
        }
        Runnable runnable = () -> {
            HttpRequestUtil.downloadFile(downloadDocumentUrl, headers, fileOutputStream);
            if (completeCallback != null) {
                eventArgs.setPercentage(1);
                completeCallback.callback(eventArgs);
            }
        };
        es.execute(runnable);
        return this;
    }

    /**
     * 设置完成
     *
     * @param callbackable
     */
    @Override
    public IGeneralDocumentDownloader onCompleted(IDownLoadCallbackable callbackable) {
        this.completeCallback = callbackable;
        return this;
    }
}
