package com.digiwin.dmc.sdk.service.upload;

import com.digiwin.dmc.sdk.config.DmcUrl;
import com.digiwin.dmc.sdk.config.SDKConstants;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.IUserManagerService;
import com.digiwin.dmc.sdk.service.impl.UserManagerService;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.ObjectMapperUtil;
import com.digiwin.dmc.sdk.util.StringUtil;

import java.io.*;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * @author chenzwd
 * @date : 2018-06-30 16:04
 * @Description:
 */
public class GeneralDocumentUploader implements IGeneralDocumentUploader {

    private String tenantId;
    private String bucketName;
    private String driveToken;
    private FileInfo fileInfo;
    private FileInputStream fileInputStream;
    private InputStream inputStream;
    private IUpLoadCallbackable completeCallback;
    private UploadProgressEventArgs eventArgs = new UploadProgressEventArgs();

    private static ExecutorService es = Executors.newCachedThreadPool();
    private static IUserManagerService userManagerService = UserManagerService.userInstance();

    public GeneralDocumentUploader(String tenantId, String bucketName, String localPath, FileInfo fileInfo, String driveToken) {
        try {
            File file = new File(localPath);
            this.fileInputStream = new FileInputStream(file);
        } catch (Exception e) {
            throw new OperateException(e);
        }
        this.tenantId = tenantId;
        this.fileInfo = fileInfo;
        this.bucketName = bucketName;
        this.driveToken = driveToken;
    }


    public GeneralDocumentUploader(String tenantId, String bucketName, byte[] bytes, FileInfo fileInfo, String driveToken) {
        try {
            this.inputStream= new ByteArrayInputStream(bytes);
        } catch (Exception e) {
            throw new OperateException(e);
        }
        this.tenantId = tenantId;
        this.fileInfo = fileInfo;
        this.bucketName = bucketName;
        this.driveToken = driveToken;
    }

    /**
     * 上传Stream中的文件内容，同步模式
     *
     * @return
     */
    @Override
    public IGeneralDocumentUploader upload() {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String uploadResourceUrl = DmcUrl.getUploadResourceUrl()
                + bucketName + "/files";
        try {
            Map<String, String> headers = new HashMap<>();
            if (StringUtil.isEmpty(driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
            }
            if (tenantId != null) {
                headers.put(SDKConstants.HTTP_HEADER_TENANTID_KEY, tenantId);
            }
            headers.put(SDKConstants.HttpHeaderApiArgKey, URLEncoder.encode(ObjectMapperUtil.writeValueAsString(fileInfo), "UTF-8"));

            Runnable runnable = () -> {
                Map<String, String> result;
                if (fileInputStream==null){
                    result = HttpRequestUtil.uploadFile(uploadResourceUrl, headers, inputStream, HashMap.class);
                }else {
                    result = HttpRequestUtil.uploadFile(uploadResourceUrl, headers, fileInputStream, HashMap.class);
                }
                String fileId = result.get("id");
                if (completeCallback != null) {
                    eventArgs.setFileId(fileId);
                    eventArgs.setPercentage(1);
                    completeCallback.callback(eventArgs);
                }
            };
            es.execute(runnable);
            return this;
        } catch (Exception e) {
            throw new OperateException(e);
        }
    }

    /**
     * 设置完成
     *
     * @param callbackable
     */
    @Override
    public IGeneralDocumentUploader onCompleted(IUpLoadCallbackable callbackable) {
        this.completeCallback = callbackable;
        return this;
    }
}
