package com.digiwin.dmc.sdk.util;

import com.digiwin.dmc.sdk.serializer.*;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

/**
 * @author chenxsa
 * @Description 全局支持跨域访问api
 */
public class ObjectMapperUtil {
    /**
     * 序列化实体
     * @param data 对象
     * @return json
     * @throws JsonProcessingException
     */
    public  static  String writeValueAsString(Object data) throws JsonProcessingException {
       return  createObjectMapper().writeValueAsString(data);
    }

    /**
     * 反序列化对象
     * @param json json
     * @param valueType 实体类型
     * @param <T> 泛型
     * @return 对象
     * @throws IOException
     */
    public  static  <T> T readValue(String json, Class<T> valueType) throws IOException {
        return createObjectMapper().readValue(json,valueType);
    }

    static ObjectMapper objectMapper =null;

    /**
     * 返回全局唯一的ObjectMapper
     *
     * @param
     * @return
     * @author chenxsa
     * @date 2018-5-16 15:38
     */
    public static ObjectMapper createObjectMapper(){
        if (objectMapper ==null) {
            synchronized (ObjectMapperUtil.class) {
                if (objectMapper == null) {
                    objectMapper = new ObjectMapper();
                    JavaTimeModule javaTimeModule = new JavaTimeModule();
                    javaTimeModule.addSerializer(LocalDate.class, new LocalDateSerializer());
                    javaTimeModule.addDeserializer(LocalDate.class, new LocalDateDeserializer());
                    javaTimeModule.addSerializer(LocalDateTime.class, new LocalDateTimeSerializer());
                    javaTimeModule.addDeserializer(LocalDateTime.class, new LocalDateTimeDeserializer());
                    javaTimeModule.addSerializer(LocalTime.class, new LocalTimeSerializer());
                    javaTimeModule.addDeserializer(LocalTime.class, new LocalTimeDeserializer());
                    javaTimeModule.addSerializer(Timestamp.class, new TimestampSerializer());
                    javaTimeModule.addDeserializer(Timestamp.class, new TimestampDeserializer());
                    objectMapper.registerModule(javaTimeModule);
                    objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, Boolean.FALSE);
//                    objectMapper.setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
                    objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, Boolean.FALSE);
                    //objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                }
            }
        }
        return objectMapper;
    }

}
