/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.common.auth;

import com.digiwin.dap.middleware.dmc.common.auth.InvalidTokenException;
import com.digiwin.dap.middleware.dmc.internal.DMCUtils;
import com.digiwin.dap.middleware.dmc.internal.operation.DMCLoginOperation;
import com.digiwin.dmc.sdk.util.JwtUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AuthCache {
    private final Map<String, String> tokenMap = new ConcurrentHashMap<String, String>();
    private DMCLoginOperation loginOperation;

    public void setLoginOperation(DMCLoginOperation loginOperation) {
        this.loginOperation = loginOperation;
    }

    public void addToken(String tenantId, String token) {
        this.tokenMap.put(tenantId, token);
    }

    public String getToken(String tenantId) {
        String token = this.tokenMap.get(tenantId);
        if (token == null || JwtUtil.isExpires(token)) {
            try {
                return this.loginOperation.login(tenantId);
            }
            catch (Exception e) {
                throw new InvalidTokenException(DMCUtils.DMC_RESOURCE_MANAGER.getFormattedString("LoginError", e.getMessage()), e);
            }
        }
        return token;
    }

    public void removeToken(String tenantId) {
        this.tokenMap.remove(tenantId);
    }

    public void clear() {
        this.tokenMap.clear();
    }
}

