/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.common.comm;

import com.digiwin.dap.middleware.dmc.ClientConfiguration;
import com.digiwin.dap.middleware.dmc.common.auth.AuthCache;
import com.digiwin.dap.middleware.dmc.common.comm.ExecutionContext;
import com.digiwin.dap.middleware.dmc.common.comm.HttpRequestFactory;
import com.digiwin.dap.middleware.dmc.common.comm.IdleConnectionReaper;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ResponseMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.common.utils.ExceptionFactory;
import com.digiwin.dap.middleware.dmc.common.utils.HttpUtil;
import com.digiwin.dap.middleware.dmc.common.utils.IOUtils;
import com.digiwin.dap.middleware.dmc.internal.DMCConfig;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;

public class DefaultServiceClient
extends ServiceClient {
    protected static HttpRequestFactory httpRequestFactory = new HttpRequestFactory();
    protected CloseableHttpClient httpClient;
    protected HttpClientConnectionManager connectionManager;
    protected RequestConfig requestConfig;
    protected DMCConfig config;
    protected AuthCache authCache = new AuthCache();

    public DefaultServiceClient() {
        this(DMCConfig.build());
    }

    public DefaultServiceClient(DMCConfig config) {
        this(config, new ClientConfiguration());
    }

    public DefaultServiceClient(DMCConfig config, ClientConfiguration clientConfig) {
        super(clientConfig);
        this.connectionManager = this.createHttpClientConnectionManager();
        this.httpClient = this.createHttpClient(this.connectionManager);
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(clientConfig.getConnectionTimeout());
        builder.setSocketTimeout(clientConfig.getSocketTimeout());
        builder.setConnectionRequestTimeout(clientConfig.getConnectionRequestTimeout());
        this.requestConfig = builder.build();
        this.config = config;
    }

    private static ResponseMessage buildResponse(RequestMessage request, CloseableHttpResponse httpResponse) throws IOException {
        assert (httpResponse != null);
        ResponseMessage response = new ResponseMessage();
        response.setUrl(request.getEndpoint().toString());
        if (httpResponse.getStatusLine() != null) {
            response.setStatusCode(httpResponse.getStatusLine().getStatusCode());
        }
        if (httpResponse.getEntity() != null) {
            response.setContent(httpResponse.getEntity().getContent());
            if (!response.isSuccessful()) {
                byte[] contentBytes = IOUtils.readStreamAsByteArray(response.getContent());
                response.setError(new String(contentBytes));
            }
        }
        for (Header header : httpResponse.getAllHeaders()) {
            if ("Content-Length".equalsIgnoreCase(header.getName())) {
                response.setContentLength(Long.parseLong(header.getValue()));
            }
            response.addHeader(header.getName(), header.getValue());
        }
        HttpUtil.convertHeaderCharsetFromIso88591(response.getHeaders());
        return response;
    }

    @Override
    public ResponseMessage sendRequestCore(RequestMessage request, ExecutionContext context) throws IOException {
        CloseableHttpResponse httpResponse;
        HttpRequestBase httpRequest = httpRequestFactory.createHttpRequest(request);
        this.setUserTokenIfNeed(request, httpRequest);
        HttpClientContext httpContext = this.createHttpContext();
        try {
            httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest, (HttpContext)httpContext);
        }
        catch (IOException ex) {
            httpRequest.abort();
            throw ExceptionFactory.createNetworkException(ex);
        }
        return DefaultServiceClient.buildResponse(request, httpResponse);
    }

    @Override
    public DMCConfig getConfig() {
        return this.config;
    }

    @Override
    public AuthCache getAuthCache() {
        return this.authCache;
    }

    @Override
    public void setAuthCache(String tenantId, String token) {
        this.config.setTenantId(tenantId);
        this.authCache.addToken(tenantId, token);
    }

    @Override
    public void shutdown() {
        IdleConnectionReaper.removeConnectionManager(this.connectionManager);
        this.connectionManager.shutdown();
    }

    private HttpClientConnectionManager createHttpClientConnectionManager() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(this.clientConfig.getMaxConnections());
        connectionManager.setMaxTotal(this.clientConfig.getMaxConnections());
        connectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.clientConfig.getSocketTimeout()).build());
        if (this.clientConfig.isUseReaper()) {
            IdleConnectionReaper.setIdleConnectionTime(this.clientConfig.getIdleConnectionTime());
            IdleConnectionReaper.registerConnectionManager((HttpClientConnectionManager)connectionManager);
        }
        return connectionManager;
    }

    private CloseableHttpClient createHttpClient(HttpClientConnectionManager connectionManager) {
        return HttpClients.custom().setConnectionManager(connectionManager).disableContentCompression().disableAutomaticRetries().build();
    }

    private void setUserTokenIfNeed(RequestMessage request, HttpRequestBase httpRequest) {
        if (!request.isWhitelist()) {
            httpRequest.setHeader("digi-middleware-auth-user", this.authCache.getToken(this.config.getTenantId()));
        }
    }

    private HttpClientContext createHttpContext() {
        HttpClientContext httpContext = HttpClientContext.create();
        httpContext.setRequestConfig(this.requestConfig);
        return httpContext;
    }
}

