/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.internal;

import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.util.AESCipher;
import java.net.URI;

public class DMCConfig {
    private static final String LOGIN = "%s/api/dmc/v1/auth/login";
    private static final String REFRESH = "%s/api/dmc/v1/auth/token/refresh";
    private static final String UPLOAD = "%s/api/dmc/v2/file/%s/upload";
    private static final String UPLOAD_MULTI = "%s/api/dmc/v2/file/%s/upload/multi";
    private static final String UPLOAD_EMPTY = "%s/api/dmc/v1/buckets/%s/files/segment";
    private static final String UPLOAD_MULTIPART = "%s/api/dmc/v1/buckets/%s/files/%s/%s/%s/%s";
    private static final String DOWNLOAD = "%s/api/dmc/v2/file/%s/download/%s";
    private static final String DOWNLOAD_MULTI = "%s/api/dmc/v2/file/%s/download/multi";
    private static final String DELETE = "%s/api/dmc/v2/file/%s/delete/%s";
    private static final String DELETE_MULTI = "%s/api/dmc/v2/file/%s/delete";
    private static final String DELETE_FORCE = "%s/api/dmc/v2/file/%s/delete/force/%s";
    private static final String DELETE_FORCE_MULTI = "%s/api/dmc/v2/file/%s/delete/force";
    private static final String RECYCLE = "%s/api/dmc/v2/file/%s/recycle/delete/%s";
    private static final String RECYCLE_CLEAR = "%s/api/dmc/v2/file/%s/recycle/clear";
    private static final String RECYCLE_RESTORE = "%s/api/dmc/v2/file/%s/recycle/restore/%s";
    private static final String RECYCLE_RESTORE_MULTI = "%s/api/dmc/v2/file/%s/recycle/restore";
    private static final String COPY = "%s/api/dmc/v2/file/%s/copy/%s/%s";
    private static final String COPY_DIR = "%s/api/dmc/v2/file/%s/copy/dir/%s/%s";
    private static final String COPY_MULTI = "%s/api/dmc/v2/file/%s/copy/%s";
    private static final String MOVE = "%s/api/dmc/v2/file/%s/move/%s/%s";
    private static final String MOVE_DIR = "%s/api/dmc/v2/file/%s/move/dir/%s/%s";
    private static final String MOVE_MULTI = "%s/api/dmc/v2/file/%s/move/%s";
    private static final String SHARE_MULTI = "%s/api/dmc/v2/file/%s/share";
    private static final String SHARE_DELETE_MULTI = "%s/api/dmc/v2/file/%s/share/delete";
    private static final String IMAGE_UPLOAD = "%s/api/dmc/v1/buckets/%s/images/upload?shrink=1&width=%s&height=%s";
    private static final String IMAGE_SHRINK = "%s/api/dmc/v1/buckets/%s/images/%s?shrink=1&width=%s&height=%s&share=%s";
    private static final String IMAGE = "%s/api/dmc/v1/buckets/%s/images/%s/%s";
    private static final String DIR_ADD = "%s/api/dmc/v2/directory/%s";
    private static final String DIR_MOD = "%s/api/dmc/v2/directory/%s";
    private static final String DIR_GET = "%s/api/dmc/v2/directory/%s/%s";
    private static final String DIR_GET_BY_NAME = "%s/api/dmc/v1/buckets/%s/directorys/%s/%s";
    private static final String FILE_MOD = "%s/api/dmc/v2/fileinfo/%s";
    private static final String FILE_GET = "%s/api/dmc/v2/fileinfo/%s/%s";
    private String uri;
    private String username;
    private String password;
    private String pwdhash;
    private String tenantId = "default";
    private String bucket;

    private DMCConfig() {
    }

    public static DMCConfig build() {
        return DMCConfig.build("default");
    }

    public static DMCConfig build(String tenantId) {
        DMCConfig config = new DMCConfig();
        config.setUri(ServerSetting.getServiceUrl());
        config.setUsername(ServerSetting.getIdentityName());
        config.setPassword(ServerSetting.getIdentityPwd());
        config.setPwdhash(ServerSetting.getUser().getPasswordHash());
        config.setTenantId(tenantId);
        config.setBucket(ServerSetting.getBucketName());
        return config;
    }

    public static DMCConfig build(String uri, String username, String password, String bucket) {
        DMCConfig config = new DMCConfig();
        config.setUri(uri);
        config.setUsername(username);
        config.setPassword(password);
        if (password != null) {
            config.setPwdhash(AESCipher.getSHA256StrJava(password));
        }
        config.setBucket(bucket);
        return config;
    }

    public static DMCConfig build(String uri, String username, String password, String tenantId, String bucket) {
        DMCConfig config = new DMCConfig();
        config.setUri(uri);
        config.setUsername(username);
        config.setPassword(password);
        if (password != null) {
            config.setPwdhash(AESCipher.getSHA256StrJava(password));
        }
        config.setTenantId(tenantId);
        config.setBucket(bucket);
        return config;
    }

    public static void check(DMCConfig config) {
        if (config == null) {
            throw new DMCException("DMC\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (config.getUri() == null) {
            throw new DMCException("DMC\u670d\u52a1\u5730\u5740[uri]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (config.getUsername() == null) {
            throw new DMCException("DMC\u7528\u6237\u540d[username]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (config.getPwdhash() == null) {
            throw new DMCException("DMC\u7528\u6237\u5bc6\u7801[pwdhash]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (config.getBucket() == null) {
            throw new DMCException("DMC\u6570\u636e\u5e93[bucket]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPwdhash() {
        return this.pwdhash;
    }

    public void setPwdhash(String pwdhash) {
        this.pwdhash = pwdhash;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public URI getLoginUrl() {
        return URI.create(String.format(LOGIN, this.uri));
    }

    public URI getRefreshUrl() {
        return URI.create(String.format(REFRESH, this.uri));
    }

    public URI getUploadUrl() {
        return URI.create(String.format(UPLOAD, this.uri, this.bucket));
    }

    public URI getUploadMultiUrl() {
        return URI.create(String.format(UPLOAD_MULTI, this.uri, this.bucket));
    }

    public URI getUploadEmptyUrl() {
        return URI.create(String.format(UPLOAD_EMPTY, this.uri, this.bucket));
    }

    public URI getUploadMultipartUrl(String fileId, long from, long to, long total) {
        return URI.create(String.format(UPLOAD_MULTIPART, this.uri, this.bucket, fileId, from, to, total));
    }

    public URI getDownloadUrl(String fileId) {
        return URI.create(String.format(DOWNLOAD, this.uri, this.bucket, fileId));
    }

    public URI getDownloadMultiUrl() {
        return URI.create(String.format(DOWNLOAD_MULTI, this.uri, this.bucket));
    }

    public URI getDeleteUrl(String fileId) {
        return URI.create(String.format(DELETE, this.uri, this.bucket, fileId));
    }

    public URI getDeleteMultiUrl() {
        return URI.create(String.format(DELETE_MULTI, this.uri, this.bucket));
    }

    public URI getDeleteForceUrl(String fileId) {
        return URI.create(String.format(DELETE_FORCE, this.uri, this.bucket, fileId));
    }

    public URI getDeleteForceMultiUrl() {
        return URI.create(String.format(DELETE_FORCE_MULTI, this.uri, this.bucket));
    }

    public URI getRecycleUrl(String recycleId) {
        return URI.create(String.format(RECYCLE, this.uri, this.bucket, recycleId));
    }

    public URI getRecycleClearUrl() {
        return URI.create(String.format(RECYCLE_CLEAR, this.uri, this.bucket));
    }

    public URI getRecycleRestoreUrl(String recycleId) {
        return URI.create(String.format(RECYCLE_RESTORE, this.uri, this.bucket, recycleId));
    }

    public URI getRecycleRestoreMultiUrl() {
        return URI.create(String.format(RECYCLE_RESTORE_MULTI, this.uri, this.bucket));
    }

    public URI getCopyUrl(String fileId, String targetDirId) {
        return URI.create(String.format(COPY, this.uri, this.bucket, fileId, targetDirId));
    }

    public URI getCopyDirUrl(String dirId, String targetDirId) {
        return URI.create(String.format(COPY_DIR, this.uri, this.bucket, dirId, targetDirId));
    }

    public URI getCopyMultiUrl(String targetDirId) {
        return URI.create(String.format(COPY_MULTI, this.uri, this.bucket, targetDirId));
    }

    public URI getMoveUrl(String fileId, String targetDirId) {
        return URI.create(String.format(MOVE, this.uri, this.bucket, fileId, targetDirId));
    }

    public URI getMoveDirUrl(String dirId, String targetDirId) {
        return URI.create(String.format(MOVE_DIR, this.uri, this.bucket, dirId, targetDirId));
    }

    public URI getMoveMultiUrl(String targetDirId) {
        return URI.create(String.format(MOVE_MULTI, this.uri, this.bucket, targetDirId));
    }

    public URI getShareMultiUrl() {
        return URI.create(String.format(SHARE_MULTI, this.uri, this.bucket));
    }

    public URI getShareDeleteMultiUrl() {
        return URI.create(String.format(SHARE_DELETE_MULTI, this.uri, this.bucket));
    }

    public URI getImageUploadUrl(int width, int height) {
        return URI.create(String.format(IMAGE_UPLOAD, this.uri, this.bucket, width, height));
    }

    public URI getImageShrinkUrl(String fileId, int width, int height, boolean share) {
        return URI.create(String.format(IMAGE_SHRINK, this.uri, this.bucket, fileId, width, height, share));
    }

    public URI getImageUrl(String fileId, boolean shrink) {
        return URI.create(String.format(IMAGE, this.uri, this.bucket, fileId, shrink));
    }

    public URI getDirInfoAddUrl() {
        return URI.create(String.format("%s/api/dmc/v2/directory/%s", this.uri, this.bucket));
    }

    public URI getDirInfoModUrl() {
        return URI.create(String.format("%s/api/dmc/v2/directory/%s", this.uri, this.bucket));
    }

    public URI getDirInfoGetUrl(String dirId) {
        return URI.create(String.format(DIR_GET, this.uri, this.bucket, dirId));
    }

    public URI getDirInfoGetByNameUrl(String parentDirId, String dirName) {
        return URI.create(String.format(DIR_GET_BY_NAME, this.uri, this.bucket, parentDirId, dirName));
    }

    public URI getFileInfoModUrl() {
        return URI.create(String.format(FILE_MOD, this.uri, this.bucket));
    }

    public URI getFileInfoGetUrl(String fileId) {
        return URI.create(String.format(FILE_GET, this.uri, this.bucket, fileId));
    }
}

