/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.internal;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.internal.model.WebServiceRequest;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;

public class DMCRequestMessageBuilder {
    private URI endpoint;
    private HttpMethod method = HttpMethod.GET;
    private Map<String, String> headers = new HashMap<String, String>();
    private HttpEntity entity;
    private boolean whitelist;
    private InputStream input;
    private long inputSize = 0L;
    private WebServiceRequest originalRequest;

    public static DMCRequestMessageBuilder create() {
        return new DMCRequestMessageBuilder();
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public DMCRequestMessageBuilder setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public DMCRequestMessageBuilder setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public DMCRequestMessageBuilder setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public DMCRequestMessageBuilder addHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public DMCRequestMessageBuilder setEntity(HttpEntity entity) {
        this.entity = entity;
        return this;
    }

    public DMCRequestMessageBuilder setWhitelist(boolean whitelist) {
        this.whitelist = whitelist;
        return this;
    }

    public InputStream getInput() {
        return this.input;
    }

    public DMCRequestMessageBuilder setInput(InputStream instream) {
        this.input = instream;
        return this;
    }

    public DMCRequestMessageBuilder setInputSize(long inputSize) {
        this.inputSize = inputSize;
        return this;
    }

    public DMCRequestMessageBuilder setOriginalRequest(WebServiceRequest originalRequest) {
        this.originalRequest = originalRequest;
        return this;
    }

    public RequestMessage build() {
        HashMap<String, String> sentHeaders = new HashMap<String, String>(this.headers);
        sentHeaders.put("Content-Length", this.inputSize + "");
        RequestMessage request = new RequestMessage(this.originalRequest);
        request.setEndpoint(this.endpoint);
        request.setMethod(this.method);
        request.setHeaders(sentHeaders);
        request.setContent(this.input);
        request.setContentLength(this.inputSize);
        request.setHttpEntity(this.entity);
        request.setWhitelist(this.whitelist);
        return request;
    }
}

