/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.dmc.sdk.util.JsonUtils;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class UploadMultiRequest
extends GenericRequest {
    private List<File> files = new ArrayList<File>();
    private List<byte[]> bytes = new ArrayList<byte[]>();
    private List<InputStream> inputs = new ArrayList<InputStream>();
    private List<FileInfo> fileInfos = new ArrayList<FileInfo>();

    public List<File> getFiles() {
        return this.files;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public List<byte[]> getBytes() {
        return this.bytes;
    }

    public void setBytes(List<byte[]> bytes) {
        this.bytes = bytes;
    }

    public List<InputStream> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<InputStream> inputs) {
        this.inputs = inputs;
    }

    public List<FileInfo> getFileInfos() {
        return this.fileInfos;
    }

    public void setFileInfos(List<FileInfo> fileInfos) {
        this.fileInfos = fileInfos;
    }

    @Override
    public HttpEntity getEntity() {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        if (!this.files.isEmpty()) {
            this.files.forEach(file -> builder.addBinaryBody("files", file));
        } else if (!this.bytes.isEmpty()) {
            for (int i = 0; i < this.bytes.size(); ++i) {
                builder.addBinaryBody("files", this.bytes.get(i), ContentType.DEFAULT_BINARY, this.fileInfos.get(i).getFileName());
            }
        } else if (!this.inputs.isEmpty()) {
            for (int i = 0; i < this.inputs.size(); ++i) {
                builder.addBinaryBody("files", this.inputs.get(i), ContentType.DEFAULT_BINARY, this.fileInfos.get(i).getFileName());
            }
        }
        if (!this.fileInfos.isEmpty()) {
            builder.addTextBody("fileInfos", JsonUtils.writeValueAsString(this.fileInfos), ContentType.create((String)"application/json", (Charset)Consts.UTF_8));
        }
        return builder.build();
    }
}

