/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.download;

import com.digiwin.dmc.sdk.config.DmcUrl;
import com.digiwin.dmc.sdk.config.SDKConstants;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.service.IUserManagerService;
import com.digiwin.dmc.sdk.service.download.DownloadProgressEventArgs;
import com.digiwin.dmc.sdk.service.download.IFileService;
import com.digiwin.dmc.sdk.service.impl.UserManagerService;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.StringUtil;
import java.util.HashMap;

public class FileService
implements IFileService {
    private static FileService fileService;
    private static IUserManagerService userManagerService;
    private DownloadProgressEventArgs eventArgs = new DownloadProgressEventArgs();

    public static IFileService fileInstance() {
        if (fileService == null) {
            fileService = new FileService();
        }
        return fileService;
    }

    @Override
    public byte[] download(String fileId) {
        return this.download(null, null, fileId, null);
    }

    @Override
    public byte[] download(String bucketName, String fileId) {
        return this.download(null, bucketName, fileId, null);
    }

    @Override
    @Deprecated
    public byte[] download(String tenantId, String bucketName, String fileId) {
        return this.download(tenantId, bucketName, fileId, null);
    }

    @Override
    @Deprecated
    public byte[] download(String tenantId, String bucketName, String fileId, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String downloadDocumentUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/" + fileId;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtil.isEmpty(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        if (tenantId != null) {
            headers.put("tenantId", tenantId);
        }
        return HttpRequestUtil.getByte(downloadDocumentUrl, headers);
    }

    static {
        userManagerService = UserManagerService.userInstance();
    }
}

