/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.download;

import com.digiwin.dmc.sdk.config.DmcUrl;
import com.digiwin.dmc.sdk.config.NetworkOptions;
import com.digiwin.dmc.sdk.config.SDKConstants;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.IUserManagerService;
import com.digiwin.dmc.sdk.service.download.DownloadProcessState;
import com.digiwin.dmc.sdk.service.download.DownloadProgressEventArgs;
import com.digiwin.dmc.sdk.service.download.IDownLoadCallbackable;
import com.digiwin.dmc.sdk.service.download.ISegmentDocumentDownloader;
import com.digiwin.dmc.sdk.service.impl.UserManagerService;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public class SegmentSegmentDocumentDownloader
implements ISegmentDocumentDownloader,
Runnable {
    private static final IUserManagerService userManagerService = UserManagerService.userInstance();
    private static final ThreadFactory threadFactory = new DefaultThreadFactory();
    private final Thread thread = threadFactory.newThread(this);
    private final String tenantId;
    private final String bucketName;
    private final String fileId;
    private final String driveToken;
    private final int bufferSize = NetworkOptions.Default.getPackageSize();
    private final DownloadProgressEventArgs eventArgs = new DownloadProgressEventArgs();
    private volatile DownloadProcessState state;
    private FileOutputStream fileOutputStream;
    private IDownLoadCallbackable completeCallback;
    private IDownLoadCallbackable progressChangedCallback;

    public SegmentSegmentDocumentDownloader(String tenantId, String bucketName, String fileId, String saveToPath, int fileSize, String driveToken) {
        try {
            File file = new File(saveToPath);
            if (!file.exists()) {
                file.createNewFile();
            }
            this.fileOutputStream = new FileOutputStream(file);
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
        this.state = DownloadProcessState.NotStarted;
        this.tenantId = tenantId;
        this.bucketName = bucketName;
        this.fileId = fileId;
        this.driveToken = driveToken;
        this.eventArgs.setTotalBytes(fileSize);
    }

    @Override
    public ISegmentDocumentDownloader beginDownload() {
        if (this.state != DownloadProcessState.NotStarted) {
            throw new OperateException("\u4e0b\u8f7d\u5df2\u5f00\u59cb\uff0c\u65e0\u6cd5\u518d\u6b21\u542f\u52a8\u4e0b\u8f7d\uff0c\u8bf7\u5f00\u542f\u65b0\u7684\u4e0b\u8f7d");
        }
        this.continueDownload();
        this.thread.start();
        return this;
    }

    @Override
    public void run() {
        this.multipartDownload(this.bucketName);
    }

    private void multipartDownload(String bucketName) {
        try {
            int totalBytes = this.eventArgs.getTotalBytes();
            int downloadBytes = 0;
            while (downloadBytes < totalBytes) {
                if (this.state == DownloadProcessState.Stopped) {
                    return;
                }
                if (this.state == DownloadProcessState.Paused) {
                    LockSupport.park(this.thread);
                    continue;
                }
                int from = downloadBytes;
                if (downloadBytes + this.bufferSize >= totalBytes) {
                    this.download(bucketName, from, totalBytes - downloadBytes);
                    downloadBytes = totalBytes;
                    this.eventArgs.setCompletedBytes(totalBytes);
                    this.eventArgs.setPercentage(1.0);
                    if (this.progressChangedCallback != null) {
                        this.progressChangedCallback.callback(this.eventArgs);
                    }
                    if (this.completeCallback == null) continue;
                    this.completeCallback.callback(this.eventArgs);
                    continue;
                }
                this.download(bucketName, from, this.bufferSize);
                this.eventArgs.setCompletedBytes(downloadBytes += this.bufferSize);
                this.eventArgs.setPercentage((double)Math.round((double)this.eventArgs.getCompletedBytes() * 10000.0 / (double)totalBytes) / 10000.0);
                if (this.progressChangedCallback == null) continue;
                this.progressChangedCallback.callback(this.eventArgs);
            }
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    private void download(String bucketName, int bytesReaded, int count) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String downloadResourceUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/" + this.fileId + "/" + bytesReaded + "/" + count;
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            if (StringUtil.isEmpty(this.driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, this.driveToken);
            }
            if (this.tenantId != null) {
                headers.put("tenantId", this.tenantId);
            }
            this.fileOutputStream = HttpRequestUtil.downloadSegFile(downloadResourceUrl, headers, count, this.fileOutputStream);
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public ISegmentDocumentDownloader onProgressChanged(IDownLoadCallbackable callbackable) {
        this.progressChangedCallback = callbackable;
        return this;
    }

    @Override
    public ISegmentDocumentDownloader onCompleted(IDownLoadCallbackable callbackable) {
        this.completeCallback = callbackable;
        return this;
    }

    @Override
    public void pauseDownload() {
        this.state = DownloadProcessState.Paused;
    }

    @Override
    public void continueDownload() {
        if (this.state == DownloadProcessState.Paused) {
            LockSupport.unpark(this.thread);
        }
        this.state = DownloadProcessState.Downloading;
    }

    @Override
    public void stopDownload() {
        this.state = DownloadProcessState.Stopped;
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        DefaultThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "dmc-part-download-thread-" + this.threadNumber.getAndIncrement());
        }
    }
}

