/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.impl;

import com.digiwin.dmc.sdk.config.DmcUrl;
import com.digiwin.dmc.sdk.config.SDKConstants;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.BucketInfo;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.IBucketManagerService;
import com.digiwin.dmc.sdk.service.IUserManagerService;
import com.digiwin.dmc.sdk.service.impl.UserManagerService;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.ObjectMapperUtil;
import com.digiwin.dmc.sdk.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BucketManagerService
implements IBucketManagerService {
    private static BucketManagerService bucketManagerService;
    private static IUserManagerService userManagerService;

    public static IBucketManagerService bucketInstance() {
        if (bucketManagerService == null) {
            bucketManagerService = new BucketManagerService();
        }
        return bucketManagerService;
    }

    @Override
    public String createBucket(BucketInfo bucketInfo) {
        return this.createBucketByTenant(null, bucketInfo);
    }

    @Override
    public String createBucketByTenant(String tenantId, BucketInfo bucketInfo) {
        if (bucketInfo == null) {
            throw new IllegalArgumentException("\u53c2\u6570bucketInfo is null");
        }
        if (StringUtil.checkSpecialId(bucketInfo.getName())) {
            throw new IllegalArgumentException("bucketName\u4e3a\u7a7a\u6216\u5305\u542b\u7279\u6b8a\u5b57\u7b26.\u53f7\uff01");
        }
        String url = DmcUrl.getBucketResourceUrl();
        String userToken = userManagerService.getUserToken(ServerSetting.getUser());
        HashMap<String, String> bucketMap = new HashMap<String, String>();
        bucketMap.put("name", bucketInfo.getName());
        bucketMap.put("keytype", bucketInfo.getKeyType().toLowerCase());
        bucketMap.put("description", bucketInfo.getDescription());
        try {
            HashMap responseEntity;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            if (!StringUtil.isEmpty(tenantId)) {
                headers.put("tenantId", tenantId);
            }
            if ((responseEntity = HttpRequestUtil.postJson(url, ObjectMapperUtil.writeValueAsString(bucketMap), headers, HashMap.class)) == null || !responseEntity.containsKey("id")) {
                return null;
            }
            return responseEntity.get("id").toString();
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public List<BucketInfo> getBuckets() {
        String url = DmcUrl.getBucketResourceUrl();
        String userToken = userManagerService.getUserToken(ServerSetting.getUser());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        ArrayList buckets = HttpRequestUtil.get(url, headers, ArrayList.class);
        ArrayList<BucketInfo> bucketInfos = new ArrayList<BucketInfo>();
        if (buckets != null) {
            for (Object bucket : buckets) {
                try {
                    String json = ObjectMapperUtil.writeValueAsString(bucket);
                    BucketInfo bucketInfo = ObjectMapperUtil.readValue(json, BucketInfo.class);
                    bucketInfos.add(bucketInfo);
                }
                catch (IOException e) {
                    throw new OperateException(e);
                }
            }
        }
        return bucketInfos;
    }

    @Override
    public String isExistBucket(String bucketName) {
        return this.isExistBucketByTenant(null, bucketName);
    }

    @Override
    public String isExistBucketByTenant(String tenantId, String bucketName) {
        HashMap isExist;
        if (bucketName == null || "".equals(bucketName)) {
            throw new IllegalArgumentException("\u53c2\u6570bucketName is null");
        }
        String url = DmcUrl.getBucketResourceUrl() + "/" + bucketName + "/isExist";
        String userToken = userManagerService.getUserToken(ServerSetting.getAdmin());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        if (!StringUtil.isEmpty(tenantId)) {
            headers.put("tenantId", tenantId);
        }
        if ((isExist = HttpRequestUtil.get(url, headers, HashMap.class)) == null || !isExist.containsKey("isExist")) {
            return null;
        }
        return isExist.get("isExist").toString();
    }

    static {
        userManagerService = UserManagerService.userInstance();
    }
}

