/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.upload;

import com.digiwin.dmc.sdk.config.DmcUrl;
import com.digiwin.dmc.sdk.config.SDKConstants;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.IUserManagerService;
import com.digiwin.dmc.sdk.service.impl.UserManagerService;
import com.digiwin.dmc.sdk.service.upload.ICoverGeneralDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.IUpLoadCallbackable;
import com.digiwin.dmc.sdk.service.upload.UploadProgressEventArgs;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CoverGeneralDocumentUploader
implements ICoverGeneralDocumentUploader {
    private String tenantId;
    private String bucketName;
    private String driveToken;
    private String fileId;
    private FileInputStream fileInputStream;
    private InputStream inputStream;
    private IUpLoadCallbackable completeCallback;
    private UploadProgressEventArgs eventArgs = new UploadProgressEventArgs();
    private static ExecutorService es = Executors.newCachedThreadPool();
    private static IUserManagerService userManagerService = UserManagerService.userInstance();

    public CoverGeneralDocumentUploader(String tenantId, String bucketName, String localPath, String fileId, String driveToken) {
        try {
            FileInputStream fileInputStream;
            File file = new File(localPath);
            this.fileInputStream = fileInputStream = new FileInputStream(file);
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
        this.tenantId = tenantId;
        this.fileId = fileId;
        this.bucketName = bucketName;
        this.driveToken = driveToken;
    }

    public CoverGeneralDocumentUploader(String tenantId, String bucketName, byte[] bytes, String fileId, String driveToken) {
        try {
            this.inputStream = new ByteArrayInputStream(bytes);
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
        this.tenantId = tenantId;
        this.fileId = fileId;
        this.bucketName = bucketName;
        this.driveToken = driveToken;
    }

    @Override
    public ICoverGeneralDocumentUploader upload() {
        if (StringUtil.isEmpty(this.bucketName)) {
            this.bucketName = ServerSetting.getBucketName();
        }
        String uploadResourceUrl = DmcUrl.getUploadResourceUrl() + this.bucketName + "/files/" + this.fileId + "/cover";
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            if (StringUtil.isEmpty(this.driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, this.driveToken);
            }
            if (this.tenantId != null) {
                headers.put("tenantId", this.tenantId);
            }
            Runnable runnable = () -> {
                Map result = HttpRequestUtil.uploadFile(uploadResourceUrl, headers, this.fileInputStream, HashMap.class);
                if (this.completeCallback != null) {
                    this.eventArgs.setFileId(this.fileId);
                    this.eventArgs.setPercentage(1.0);
                    this.completeCallback.callback(this.eventArgs);
                }
            };
            es.execute(runnable);
            return this;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public ICoverGeneralDocumentUploader onCompleted(IUpLoadCallbackable callbackable) {
        this.completeCallback = callbackable;
        return this;
    }
}

