/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.upload;

import com.digiwin.dmc.sdk.config.DmcUrl;
import com.digiwin.dmc.sdk.config.NetworkOptions;
import com.digiwin.dmc.sdk.config.SDKConstants;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.IUserManagerService;
import com.digiwin.dmc.sdk.service.impl.UserManagerService;
import com.digiwin.dmc.sdk.service.upload.ISegmentDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.IUpLoadCallbackable;
import com.digiwin.dmc.sdk.service.upload.UploadProcessState;
import com.digiwin.dmc.sdk.service.upload.UploadProgressEventArgs;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.ObjectMapperUtil;
import com.digiwin.dmc.sdk.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SegmentDocumentUploader
implements ISegmentDocumentUploader {
    private static ExecutorService es = Executors.newCachedThreadPool();
    private static IUserManagerService userManagerService = UserManagerService.userInstance();
    private String tenantId;
    private String bucketName;
    private int bufferSize;
    private String driveToken;
    private UploadProcessState state;
    private FileInfo fileInfo;
    private FileInputStream fileInputStream;
    private InputStream inputStream;
    private IUpLoadCallbackable progressChangedCallback;
    private IUpLoadCallbackable completeCallback;
    private UploadProgressEventArgs eventArgs = new UploadProgressEventArgs();
    private String uploadId;

    public SegmentDocumentUploader(String tenantId, String bucketName, String localPath, FileInfo fileInfo, String driveToken) {
        try {
            FileInputStream fileInputStream;
            File file = new File(localPath);
            this.fileInputStream = fileInputStream = new FileInputStream(file);
            this.eventArgs.setTotalBytes((int)file.length());
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
        this.driveToken = driveToken;
        this.bucketName = bucketName;
        this.tenantId = tenantId;
        this.fileInfo = fileInfo;
        this.eventArgs.setPercentage(0.0);
        this.eventArgs.setCompletedBytes(0);
        this.state = UploadProcessState.NotStarted;
        this.bufferSize = NetworkOptions.Default.getPackageSize();
    }

    public SegmentDocumentUploader(String tenantId, String bucketName, byte[] bytes, FileInfo fileInfo, String driveToken) {
        try {
            this.inputStream = new ByteArrayInputStream(bytes);
            this.eventArgs.setTotalBytes(this.inputStream.available());
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
        this.driveToken = driveToken;
        this.bucketName = bucketName;
        this.tenantId = tenantId;
        this.fileInfo = fileInfo;
        this.eventArgs.setPercentage(0.0);
        this.eventArgs.setCompletedBytes(0);
        this.state = UploadProcessState.NotStarted;
        this.bufferSize = NetworkOptions.Default.getPackageSize();
    }

    @Override
    public ISegmentDocumentUploader beginUpload() {
        if (this.state != UploadProcessState.NotStarted) {
            throw new OperateException("\u4e0a\u4f20\u5df2\u5f00\u59cb\uff0c\u65e0\u6cd5\u518d\u6b21\u542f\u52a8\u4e0b\u8f7d\uff0c\u8bf7\u5f00\u542f\u65b0\u7684\u4e0a\u4f20");
        }
        if (StringUtil.isEmpty(this.bucketName)) {
            this.bucketName = ServerSetting.getBucketName();
        }
        String uploadResourceUrl = DmcUrl.getUploadResourceUrl() + this.bucketName + "/files/segment";
        try {
            String json;
            Map result;
            HashMap<String, String> headers = new HashMap<String, String>();
            if (this.driveToken == null || "".equals(this.driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, this.driveToken);
            }
            if (!StringUtil.isEmpty(this.tenantId)) {
                headers.put("tenantId", this.tenantId);
            }
            if ((result = (Map)HttpRequestUtil.postJson(uploadResourceUrl, json = ObjectMapperUtil.writeValueAsString(this.fileInfo), headers, HashMap.class)) == null) {
                throw new Exception("Response is null");
            }
            this.uploadId = (String)result.get("id");
            this.continueUpload();
            String finalBucketName = this.bucketName;
            Runnable runnable = () -> this.multipartUpload(finalBucketName);
            es.execute(runnable);
            return this;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    public void uploadSegFile(String bucketName, int from, int count, byte[] buf) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String uploadResourceUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/" + this.uploadId + "/" + from + "/" + (from + count - 1) + "/" + this.eventArgs.getTotalBytes();
        HashMap<String, String> headers = new HashMap<String, String>();
        String userToken = userManagerService.getUserToken(ServerSetting.getUser());
        headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        if (!StringUtil.isEmpty(this.tenantId)) {
            headers.put("tenantId", this.tenantId);
        }
        HttpRequestUtil.uploadSegFile(uploadResourceUrl, headers, count, buf);
    }

    public void multipartUpload(String bucketName) {
        byte[] buffer = new byte[this.bufferSize];
        int bytesReaded = 0;
        int totalBytes = this.eventArgs.getTotalBytes();
        while (bytesReaded < totalBytes) {
            try {
                bytesReaded = this.eventArgs.getCompletedBytes();
                if (this.state == UploadProcessState.Stopped) break;
                if (this.state == UploadProcessState.Paused) {
                    Thread.sleep(86400000L);
                    if (this.state != UploadProcessState.Paused) continue;
                    this.state = UploadProcessState.Timeout;
                    break;
                }
                int currentReadLen = 0;
                currentReadLen = this.fileInputStream == null ? this.inputStream.read(buffer, 0, this.bufferSize) : this.fileInputStream.read(buffer, 0, this.bufferSize);
                if (currentReadLen == -1) break;
                if (bytesReaded + this.bufferSize >= totalBytes) {
                    currentReadLen = totalBytes - bytesReaded;
                    this.uploadSegFile(bucketName, bytesReaded, currentReadLen, buffer);
                    this.eventArgs.setCompletedBytes(totalBytes);
                    this.eventArgs.setPercentage(1.0);
                    if (this.progressChangedCallback != null) {
                        this.progressChangedCallback.callback(this.eventArgs);
                    }
                    if (this.completeCallback != null) {
                        this.eventArgs.setFileId(this.uploadId);
                        this.completeCallback.callback(this.eventArgs);
                    }
                    return;
                }
                this.uploadSegFile(bucketName, bytesReaded, currentReadLen, buffer);
                this.eventArgs.setCompletedBytes(bytesReaded + currentReadLen);
                this.eventArgs.setPercentage((double)Math.round((double)this.eventArgs.getCompletedBytes() * 10000.0 / (double)totalBytes) / 10000.0);
                if (this.progressChangedCallback == null) continue;
                this.progressChangedCallback.callback(this.eventArgs);
            }
            catch (Exception e) {
                throw new OperateException(e);
            }
        }
    }

    @Override
    public ISegmentDocumentUploader onProgressChanged(IUpLoadCallbackable callbackable) {
        this.progressChangedCallback = callbackable;
        return this;
    }

    @Override
    public ISegmentDocumentUploader onCompleted(IUpLoadCallbackable callbackable) {
        this.completeCallback = callbackable;
        return this;
    }

    @Override
    public void pauseUpload() {
        this.state = UploadProcessState.Paused;
    }

    @Override
    public void continueUpload() {
        this.state = UploadProcessState.Uploading;
    }

    @Override
    public void stopUpload() {
        this.state = UploadProcessState.Stopped;
    }
}

