package com.digiwin.dap.middleware.dmc.common.auth;

import com.digiwin.dap.middleware.dmc.internal.DMCConfig;
import com.digiwin.dap.middleware.dmc.internal.DMCLogin;
import com.digiwin.dap.middleware.dmc.internal.DMCUtils;
import com.digiwin.dap.middleware.dmc.internal.operation.DMCLoginOperation;

/**
 * Provides access to credentials used for accessing DMC, these credentials are
 * used to securely sign requests to DMC.
 *
 * @author fobgochod
 * @date 2021/4/20
 */
public class AuthCache {

    private DMCLoginOperation loginOperation;

    public void setLoginOperation(DMCLoginOperation loginOperation) {
        this.loginOperation = loginOperation;
    }

    /**
     * 获取DMC userToken并缓存
     */
    public String getToken(DMCConfig config) {
        return getToken(config, config.getTenantId());
    }

    /**
     * 获取DMC userToken并缓存
     */
    public synchronized String getToken(DMCConfig config, String tenantId) {
        try {
            String uniqueKey = DMCLogin.uniqueKey(config.getUsername(), tenantId);
            // 优先获取缓存userToken
            String userToken = TokenCache.get(uniqueKey);
            if (userToken != null) {
                return userToken;
            }
            // 没有缓存，重新登录获取
            TokenCache.put(uniqueKey, loginOperation.login(config, tenantId));
            return TokenCache.get(uniqueKey);
        } catch (Exception e) {
            throw new InvalidTokenException(DMCUtils.DMC_RESOURCE_MANAGER.getFormattedString("LoginError", config.getUsername()), e);
        }
    }
}
