package com.digiwin.dap.middleware.dmc.common.auth;

import com.digiwin.dmc.sdk.util.JwtUtil;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 全局缓存
 *
 * @author fobgo
 * @date 2022/6/8 9:00
 */
public final class TokenCache {

    private static final Map<String, String> CACHE = new ConcurrentHashMap<>();

    private TokenCache() {
    }

    public static void put(String key, String token) {
        CACHE.put(key, token);
    }

    public static void remove(String key) {
        CACHE.remove(key);
    }

    public static String get(String key) {
        if (CACHE.containsKey(key)) {
            String userToken = CACHE.get(key);
            if (!JwtUtil.isExpires(userToken)) {
                return userToken;
            }
        }
        return null;
    }
}
