package com.digiwin.dap.middleware.dmc.common.comm;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.internal.model.WebServiceRequest;
import org.apache.http.HttpEntity;

import java.net.URI;

/**
 * Represent HTTP requests sent to DMC.
 *
 * @author fobgochod
 * @date 2021/4/22
 */
public class RequestMessage extends HttpMessage {

    /**
     * The original request provided by user
     */
    private final WebServiceRequest originalRequest;
    /**
     * The service endpoint to which this request should be sent
     */
    private URI endpoint;
    /**
     * The HTTP method to use when sending this request
     */
    private HttpMethod method = HttpMethod.GET;
    /**
     * the entity associated with this request
     */
    private HttpEntity httpEntity;
    /**
     * 是否白名单，白名单不需要传token
     */
    private boolean whitelist;

    public RequestMessage() {
        this(null);
    }

    public RequestMessage(WebServiceRequest originalRequest) {
        this.originalRequest = (originalRequest == null) ? WebServiceRequest.NOOP : originalRequest;
    }

    public URI getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }

    public HttpMethod getMethod() {
        return method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public HttpEntity getHttpEntity() {
        return httpEntity;
    }

    public void setHttpEntity(HttpEntity httpEntity) {
        this.httpEntity = httpEntity;
    }

    public boolean isWhitelist() {
        return whitelist;
    }

    public void setWhitelist(boolean whitelist) {
        this.whitelist = whitelist;
    }

    public WebServiceRequest getOriginalRequest() {
        return originalRequest;
    }
}
