package com.digiwin.dap.middleware.dmc.common.comm;

import com.digiwin.dap.middleware.dmc.internal.DMCHeaders;

/**
 * response message
 *
 * @author fobgochod
 * @date 2021/4/27
 */
public class ResponseMessage extends HttpMessage {

    private static final int HTTP_SUCCESS_STATUS_CODE = 200;

    private String uri;
    private int statusCode;

    /**
     * For convenience of logging invalid response
     */
    private String error;


    public String getUri() {
        return uri;
    }

    public void setUrl(String uri) {
        this.uri = uri;
    }

    public int getStatusCode() {
        return statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getRequestId() {
        return getHeaders().get(DMCHeaders.HTTP_HEADER_REQUEST_ID);
    }

    public boolean isSuccessful() {
        return statusCode / 100 == HTTP_SUCCESS_STATUS_CODE / 100;
    }
}
