package com.digiwin.dap.middleware.dmc.common.context;

import com.digiwin.dmc.sdk.entity.FileInfo;

/**
 * 租户ID，用于方法传递租户ID
 *
 * @author fobgo
 * @date 2022/6/8 15:25
 */
public class TenantId {

    private String id;

    private TenantId(String id) {
        this.id = id;
    }

    public static TenantId of(String id) {
        return new TenantId(id);
    }

    /**
     * 获取并检查传入租户ID参数
     */
    public static void checkId(TenantId... tenantId) {
        if (tenantId.length > 1) {
            throw new IllegalArgumentException("只能传一个租户ID");
        }
    }

    /**
     * 获取租户ID
     * 首先：方法参数{@link FileInfo}
     * 其次：方法参数{@link TenantId}
     * 最后；线程变量{@link TenantHolder}
     *
     * @return 租户ID
     */
    public static String getId(FileInfo fileInfo, TenantId... tenantId) {
        if (fileInfo != null && fileInfo.getTenantId() != null) {
            return fileInfo.getTenantId();
        } else if (tenantId.length == 1) {
            return tenantId[0].getId();
        }
        return TenantHolder.getContext();
    }

    public String getId() {
        return id;
    }
}
